/*
 * Decompiled with CFR 0.152.
 */
package com.cav.mserver;

import com.cav.mserver.Config;
import com.cav.mserver.MumpsSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

public abstract class MumpsConsoleSession
implements MumpsSession {
    private static Logger logger = Logger.getLogger((class$com$cav$mserver$MumpsConsoleSession == null ? (class$com$cav$mserver$MumpsConsoleSession = MumpsConsoleSession.class$("com.cav.mserver.MumpsConsoleSession")) : class$com$cav$mserver$MumpsConsoleSession).getPackage().getName());
    private static final String VALIDITY_CHECK_MCODE = "W 1";
    protected PrintStream consoleStdin;
    protected InputStream consoleStdout;
    private Boolean valid;
    private static Boolean convertHebrewToOldcode;
    private static boolean leaveNullChars;
    static /* synthetic */ Class class$com$cav$mserver$MumpsConsoleSession;

    public abstract void close();

    public InputStream execute(String command, Map parameters) {
        StringBuffer commandBuf = new StringBuffer();
        Iterator paramIter = parameters.entrySet().iterator();
        while (paramIter.hasNext()) {
            Map.Entry param = paramIter.next();
            if (commandBuf.length() > 0) {
                commandBuf.append(' ');
            }
            String value = null;
            if (param.getValue() instanceof String) {
                value = (String)param.getValue();
            } else if (param.getValue() instanceof String[]) {
                value = ((String[])param.getValue())[0];
            } else {
                throw new IllegalArgumentException("Prameter should be of class String or String[]");
            }
            commandBuf.append("S ").append(param.getKey()).append('=').append(value);
        }
        if (commandBuf.length() > 0) {
            commandBuf.append(' ');
        }
        commandBuf.append(command);
        String commandStr = commandBuf.toString();
        commandStr = commandStr.replaceAll("^\\r\\n", "\\$C(13)_\\$C(10)_\"");
        commandStr = commandStr.replaceAll("\\r\\n$", "\"_\\$C(13)_\\$C(10)");
        commandStr = commandStr.replaceAll("\\r\\n", "\"_\\$C(13)_\\$C(10)_\"");
        commandStr = commandStr.replaceAll("^\\n", "\\$C(10)_\"");
        commandStr = commandStr.replaceAll("\\n$", "\"_\\$C(10)");
        commandStr = commandStr.replaceAll("\\n", "\"_\\$C(10)_\"");
        if (!command.equals(VALIDITY_CHECK_MCODE)) {
            logger.info("Executing " + commandStr);
        }
        this.executeCommand(commandStr);
        return new MumpsConsoleInputStream(this, this.consoleStdout);
    }

    protected void executeCommand(String command) {
        try {
            if (this.consoleStdout.available() > 0) {
                logger.warning("Leftovers on socket");
            }
            while (this.consoleStdout.available() > 0) {
                this.consoleStdout.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.consoleStdin.println(this.unicodeToASCIIHebrew(command));
        this.consoleStdin.flush();
    }

    public boolean validate() {
        if (this.valid != null) {
            boolean temp = this.valid;
            this.valid = null;
            return temp;
        }
        try {
            InputStream is = this.execute(VALIDITY_CHECK_MCODE, new HashMap());
            if (is.read() == -1) {
                return false;
            }
            while (is.read() != -1) {
            }
            is.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    protected void validate(boolean valid) {
        this.valid = valid ? Boolean.TRUE : Boolean.FALSE;
    }

    private String unicodeToASCIIHebrew(String text) {
        if (convertHebrewToOldcode == null) {
            convertHebrewToOldcode = Config.getBoolean("m.oldcode_hebrew");
        }
        if (convertHebrewToOldcode.booleanValue()) {
            StringBuffer sbuf = new StringBuffer(text.length());
            for (int i = 0; i < text.length(); ++i) {
                int c = text.charAt(i);
                if (c > 1487 && c < 1521) {
                    c -= 1392;
                }
                if (c > 223 && c < 256) {
                    c -= 128;
                }
                sbuf.append((char)c);
            }
            return sbuf.toString();
        }
        return text;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        leaveNullChars = Config.getBoolean("m.leave_null_characters");
    }

    protected class MumpsConsoleInputStream
    extends InputStream {
        private int index = 0;
        private InputStream is;
        private MumpsConsoleSession session;
        private final char[] prompt = new char[]{'~', '~', '~', '>', ' '};
        private boolean receivedPrompt = false;
        private int retransmit = -1;
        private int retransnitChar;

        public MumpsConsoleInputStream(MumpsConsoleSession session, InputStream is) {
            this.is = is;
            this.session = session;
        }

        public int available() throws IOException {
            if (this.receivedPrompt) {
                return 0;
            }
            return this.is.available();
        }

        public void close() throws IOException {
        }

        public boolean equals(Object obj) {
            return this.is.equals(obj);
        }

        public int hashCode() {
            return this.is.hashCode();
        }

        public void mark(int readlimit) {
            this.is.mark(readlimit);
        }

        public boolean markSupported() {
            return this.is.markSupported();
        }

        public int read() throws IOException {
            try {
                int c;
                block10: {
                    if (this.receivedPrompt) {
                        return -1;
                    }
                    if (this.retransmit > -1) {
                        if (this.retransmit < this.index) {
                            return this.prompt[this.retransmit++];
                        }
                        if (this.retransmit == this.index) {
                            this.index = 0;
                            this.retransmit = -1;
                            return this.retransnitChar;
                        }
                    }
                    while (true) {
                        if ((c = this.is.read()) == 0 && !leaveNullChars) {
                            continue;
                        }
                        if (c != this.prompt[this.index]) break block10;
                        ++this.index;
                        if (this.index == this.prompt.length) break;
                    }
                    this.receivedPrompt = true;
                    this.session.validate(true);
                    return -1;
                }
                if (this.index > 0) {
                    if (c != 126) {
                        this.retransmit = 1;
                        this.retransnitChar = c;
                    }
                    return this.prompt[0];
                }
                return c;
            }
            catch (IOException e) {
                this.session.validate(false);
                throw e;
            }
        }

        public void reset() throws IOException {
            this.is.reset();
        }

        public long skip(long n) throws IOException {
            return this.is.skip(n);
        }

        public String toString() {
            return this.is.toString();
        }
    }
}

