/*
 * Decompiled with CFR 0.152.
 */
package com.cav.mserver;

import com.cav.mserver.MumpsSession;
import com.cav.mserver.MumpsSessionPool;
import com.cav.mserver.MumpsTypes;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MumpsQuery {
    private static Logger logger = Logger.getLogger((class$com$cav$mserver$MumpsQuery == null ? (class$com$cav$mserver$MumpsQuery = MumpsQuery.class$("com.cav.mserver.MumpsQuery")) : class$com$cav$mserver$MumpsQuery).getPackage().getName());
    private List columnTitles;
    private List columnTypes;
    private String command;
    private Map parameters;
    private List resultSet;
    static /* synthetic */ Class class$com$cav$mserver$MumpsQuery;

    public MumpsQuery(String command, Map parameters) {
        this.command = command;
        this.parameters = parameters;
    }

    public void clear() {
        this.columnTitles = new ArrayList();
        this.columnTypes = new ArrayList();
        this.resultSet = new ArrayList();
    }

    public void execute(MumpsSession mSession) throws Exception {
        String line;
        this.clear();
        InputStream mumpsOutput = mSession.execute(this.command, this.parameters);
        BufferedReader mOut = new BufferedReader(new InputStreamReader(mumpsOutput, "ISO-8859-8"));
        Pattern pattern = Pattern.compile("NAME=(.*),TYPE=(.)");
        while ((line = mOut.readLine()) != null && !line.startsWith(">>>DATA")) {
            Matcher matcher = pattern.matcher(line);
            if (matcher.matches()) {
                String name = matcher.group(1).replace('|', '\n');
                this.columnTitles.add(name);
                this.columnTypes.add(new Integer(MumpsTypes.get(matcher.group(2))));
                continue;
            }
            logger.severe("Bad column definition " + line);
        }
        int nCols = this.columnTitles.size();
        while ((line = mOut.readLine()) != null && line.trim().length() != 0) {
            int index = 0;
            ArrayList<String> rowList = new ArrayList<String>(nCols);
            boolean endOfTokens = false;
            for (int i = 0; i < nCols; ++i) {
                int nextIndex = line.indexOf(95, index);
                if (nextIndex == -1) {
                    if (!endOfTokens) {
                        rowList.add(i, line.substring(index));
                        endOfTokens = true;
                        continue;
                    }
                    rowList.add(i, "");
                    continue;
                }
                rowList.add(i, line.substring(index, nextIndex));
                index = nextIndex + 1;
            }
            this.resultSet.add(rowList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        MumpsSession mSession = (MumpsSession)MumpsSessionPool.instance().borrowObject();
        try {
            this.execute(mSession);
        }
        finally {
            MumpsSessionPool.instance().returnObject((Object)mSession);
        }
    }

    public List getColumnTitles() {
        return this.columnTitles;
    }

    public List getColumnTypes() {
        return this.columnTypes;
    }

    public String getCommand() {
        return this.command;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public List getResultSet() {
        return this.resultSet;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

