/*
 * Decompiled with CFR 0.152.
 */
package com.cav.taglibs.mumps;

import com.cav.mserver.Config;
import com.cav.taglibs.mumps.JSPMumpsSession;
import com.cav.taglibs.mumps.MumpsSetSessionIdTag;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;

public class MumpsSessionTag
extends TagSupport
implements TryCatchFinally {
    private static Logger logger = Logger.getLogger((class$com$cav$taglibs$mumps$MumpsSessionTag == null ? (class$com$cav$taglibs$mumps$MumpsSessionTag = MumpsSessionTag.class$("com.cav.taglibs.mumps.MumpsSessionTag")) : class$com$cav$taglibs$mumps$MumpsSessionTag).getPackage().getName());
    private String namespace = "MGR";
    private static final MessageFormat HTTP_M_ARG = new MessageFormat("%ARG(\"{0}\")");
    private static final MessageFormat HTTP_BODY_ARG = new MessageFormat("%BODY(\"{0}\")");
    private JSPMumpsSession session;
    private Boolean debug = Boolean.FALSE;
    static /* synthetic */ Class class$com$cav$taglibs$mumps$MumpsSessionTag;

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public JSPMumpsSession getSession() {
        return this.session;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    public int doStartTag() throws JspException {
        this.release();
        ServletRequest request = this.pageContext.getRequest();
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("%REM", JSPMumpsSession.toMString(request.getRemoteAddr()));
        requestParams.put("%NAM", JSPMumpsSession.toMString(""));
        Iterator paramIter = request.getParameterMap().entrySet().iterator();
        while (paramIter.hasNext()) {
            Map.Entry param = paramIter.next();
            requestParams.put(HTTP_M_ARG.format(new Object[]{param.getKey()}), JSPMumpsSession.toMString(((String[])param.getValue())[0]));
        }
        requestParams.put("%FORW", JSPMumpsSession.toMString(""));
        requestParams.put("%HTIP", JSPMumpsSession.toMString(request.getRemoteAddr()));
        requestParams.put("%RMAD", JSPMumpsSession.toMString(request.getRemoteAddr()));
        requestParams.put("%RMHT", JSPMumpsSession.toMString(request.getRemoteHost()));
        if (request instanceof HttpServletRequest) {
            Cookie[] cookies = ((HttpServletRequest)request).getCookies();
            if (cookies != null) {
                requestParams.put("%COOK", JSPMumpsSession.toMString(cookies.length > 0 ? cookies[0].getValue() : ""));
            } else {
                requestParams.put("%COOK", JSPMumpsSession.toMString(""));
            }
        } else {
            requestParams.put("%COOK", JSPMumpsSession.toMString(""));
        }
        requestParams.put("%PAID", JSPMumpsSession.toMString(""));
        try {
            this.session = new JSPMumpsSession(this.debug != false ? this.pageContext.getOut() : null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error creating session", e);
            return 0;
        }
        this.session.switchNamespace(this.getNamespace(), requestParams);
        MumpsSetSessionIdTag.reloadSessionId(this.session, this.pageContext);
        int bodyLine = 0;
        try {
            BufferedReader bodyReader = new BufferedReader(request.getReader());
            String line = null;
            while ((line = bodyReader.readLine()) != null) {
                this.session.set(HTTP_BODY_ARG.format(new Object[]{new Integer(++bodyLine)}), JSPMumpsSession.toMString(line));
            }
        }
        catch (IOException e) {
            throw new JspTagException("Error gentting request budy", (Throwable)e);
        }
        if (this.pageContext.getResponse().getContentType().toLowerCase().startsWith("text/html")) {
            try {
                this.initJavaScript();
            }
            catch (IOException e) {
                throw new JspTagException("Error generating needed tags for Javascript.", (Throwable)e);
            }
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        this.release();
        return 6;
    }

    private void setResponseHeaders() {
        if (this.pageContext.getResponse() instanceof HttpServletResponse) {
            HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
            response.setDateHeader("Expires", 0L);
            response.setHeader("cache-control", "no-store");
            response.setHeader("pragma", "no-cache");
        }
    }

    private void initJavaScript() throws IOException {
        String servletPath = "";
        if (this.pageContext.getRequest() instanceof HttpServletRequest) {
            servletPath = ((HttpServletRequest)this.pageContext.getRequest()).getContextPath();
        }
        this.pageContext.getOut().println("<script language=\"javascript\" type=\"text/javascript\">");
        this.pageContext.getOut().print("\tvar convertHebrewToUnicode = ");
        this.pageContext.getOut().print(Config.getBoolean("m.oldcode_hebrew") != false);
        this.pageContext.getOut().println(";");
        this.pageContext.getOut().println("</script>");
        this.pageContext.getOut().println("<script language=\"javascript\" src=\"" + servletPath + "/mapplet/script.js\"></script>");
    }

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.pageContext = pageContext;
    }

    public void release() {
        super.release();
        if (this.session != null) {
            logger.fine("Releasing session");
            this.session.close();
            this.session = null;
        } else {
            logger.fine("No session to release");
        }
    }

    public void doCatch(Throwable ex) throws Throwable {
        logger.log(Level.SEVERE, "Caught exception. Releasing session", ex);
        this.release();
        this.pageContext.getOut().println();
        this.pageContext.getOut().println("<pre>");
        this.pageContext.getOut().print("Exception occured inside m:session tag: ");
        this.pageContext.getOut().println(ex.toString());
        StringWriter stackTrace = new StringWriter();
        ex.printStackTrace(new PrintWriter(stackTrace));
        this.pageContext.getOut().print(stackTrace.toString());
        this.pageContext.getOut().println("</pre>");
        this.pageContext.getOut().flush();
        this.pageContext.handlePageException(ex);
    }

    public void doFinally() {
        logger.fine("Finally called. Releasing session");
        this.release();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

