/*
 * Decompiled with CFR 0.152.
 */
package com.cav.taglibs.mumps.cewolf;

import com.cav.mserver.MumpsQuery;
import de.laures.cewolf.DatasetProduceException;
import de.laures.cewolf.DatasetProducer;
import de.laures.cewolf.links.LinkGenerator;
import de.laures.cewolf.tooltips.ToolTipGenerator;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class MumpsChartCewolfDataProducer
implements DatasetProducer,
LinkGenerator,
ToolTipGenerator,
Serializable {
    protected static Pattern AXIS_LABEL_PATTERN = Pattern.compile("1\\.(.*) > 2\\.(.*)");
    private static Logger logger = Logger.getLogger((class$com$cav$taglibs$mumps$cewolf$MumpsChartCewolfDataProducer == null ? (class$com$cav$taglibs$mumps$cewolf$MumpsChartCewolfDataProducer = MumpsChartCewolfDataProducer.class$("com.cav.taglibs.mumps.cewolf.MumpsChartCewolfDataProducer")) : class$com$cav$taglibs$mumps$cewolf$MumpsChartCewolfDataProducer).getPackage().getName());
    protected String[] seriesNames;
    private MumpsQuery query;
    static /* synthetic */ Class class$com$cav$taglibs$mumps$cewolf$MumpsChartCewolfDataProducer;

    public MumpsChartCewolfDataProducer() {
        logger.fine("MumpsChartCewolfDataProducer Created");
    }

    protected synchronized MumpsQuery executeQuery(String mcode) throws Exception {
        MumpsQuery query = new MumpsQuery(mcode, new HashMap());
        query.execute();
        return query;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.query != null) {
            this.query.clear();
            this.query = null;
        }
        logger.fine(this + " finalized.");
    }

    public String generateLink(Object data, int series, Object category) {
        if (this.seriesNames == null || this.seriesNames.length < series) {
            return null;
        }
        return this.seriesNames[series];
    }

    public String generateToolTip(CategoryDataset arg0, int series, int arg2) {
        if (this.seriesNames == null || this.seriesNames.length < series) {
            return null;
        }
        return this.seriesNames[series];
    }

    public String getProducerId() {
        return "ZJData";
    }

    public boolean hasExpired(Map params, Date since) {
        logger.entering(this.getClass().getName(), "hasExpired");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object produceDataset(Map params) throws DatasetProduceException {
        logger.entering(this.getClass().getName(), "produceDataset");
        Class clazz = class$com$cav$taglibs$mumps$cewolf$MumpsChartCewolfDataProducer == null ? (class$com$cav$taglibs$mumps$cewolf$MumpsChartCewolfDataProducer = MumpsChartCewolfDataProducer.class$("com.cav.taglibs.mumps.cewolf.MumpsChartCewolfDataProducer")) : class$com$cav$taglibs$mumps$cewolf$MumpsChartCewolfDataProducer;
        synchronized (clazz) {
            DefaultCategoryDataset dataset = new DefaultCategoryDataset(){

                protected void finalize() throws Throwable {
                    super.finalize();
                    logger.fine((Object)((Object)this) + " finalized.");
                }
            };
            String mcode = (String)params.get("mcode");
            if (mcode == null) {
                logger.info("The Mumps code query is null, hence not generating the result set.");
                return dataset;
            }
            MumpsQuery query = null;
            try {
                query = this.executeQuery(mcode);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error executing M query", e);
                return dataset;
            }
            String xAxisLabel = "";
            String yAxisLabel = "";
            String legendLabel = "";
            if (query.getColumnTitles() == null || query.getColumnTitles().size() < 2) {
                logger.severe("Query did not return at least 2 columns: <" + mcode + '>');
                return dataset;
            }
            String[] colTitles = query.getColumnTitles().toArray(new String[0]);
            try {
                String firstCol = colTitles[0];
                Matcher matcher = AXIS_LABEL_PATTERN.matcher(firstCol);
                if (matcher.matches()) {
                    legendLabel = matcher.group(2);
                    xAxisLabel = matcher.group(1);
                }
                yAxisLabel = colTitles[colTitles.length - 1];
            }
            catch (Exception e) {
                logger.fine("Badly formatted 1st column title: " + colTitles[0]);
            }
            this.seriesNames = new String[colTitles.length - 2];
            System.arraycopy(colTitles, 1, this.seriesNames, 0, this.seriesNames.length);
            int columnNum = query.getColumnTitles().size();
            Iterator rsIter = query.getResultSet().iterator();
            while (rsIter.hasNext()) {
                List rsRow = (List)rsIter.next();
                String series = (String)rsRow.get(0);
                for (int i = 1; i < columnNum - 1; ++i) {
                    String value = (String)rsRow.get(i);
                    double doubleVal = 0.0;
                    try {
                        doubleVal = Double.parseDouble(value) * 100.0 / 100.0;
                    }
                    catch (NumberFormatException e) {
                        logger.severe("Value is not numeric: <" + value + '>');
                    }
                    dataset.addValue(doubleVal, (Comparable)((Object)series), (Comparable)((Object)colTitles[i]));
                }
            }
            return dataset;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

