/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FileTransferInputStream;
import com.enterprisedt.net.ftp.TransferDirection;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class AbstractFTPInputStream
extends FileTransferInputStream {
    private static Logger log = Logger.getLogger("AbstractFTPInputStream");
    protected FTPClient client;
    protected BufferedInputStream in;

    public AbstractFTPInputStream(FTPClient client, String remoteFile) throws IOException, FTPException {
        this.client = client;
        this.remoteFile = remoteFile;
        this.monitorInterval = client.getMonitorInterval();
        this.monitor = client.getProgressMonitor();
    }

    protected void start() throws IOException {
        this.start(true);
    }

    protected void start(boolean firstTime) throws IOException {
        try {
            if (this.pos > 0L) {
                this.client.resumeNextDownload(this.pos);
            }
            this.client.initGet(this.remoteFile);
            this.in = new BufferedInputStream(new DataInputStream(this.client.getInputStream()));
        }
        catch (FTPException ex) {
            throw new IOException(ex);
        }
        catch (IOException ex) {
            try {
                this.client.validateTransferOnError(ex);
            }
            catch (FTPException ex2) {
                throw new IOException(ex2);
            }
            throw ex;
        }
        if (firstTime && this.monitorEx != null) {
            this.monitorEx.transferStarted(TransferDirection.DOWNLOAD, this.remoteFile);
        }
        this.started = true;
        this.closed = false;
        this.monitorCount = 0L;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.client.forceResumeOff();
            this.client.closeDataSocket(this.in);
            if (this.monitor != null) {
                this.monitor.bytesTransferred(this.pos);
            }
            log.debug("Transferred " + this.pos + " bytes from remote host");
            try {
                this.client.readReply();
            }
            catch (FTPException ex) {
                throw new IOException(ex);
            }
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, this.remoteFile);
            }
        }
    }
}

