/*
 * Decompiled with CFR 0.152.
 */
package com.openrest.olo.charges;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.openrest.olo.charges.operators.Operator;
import com.wix.restaurants.conditions.Condition;
import com.wix.restaurants.i18n.LocalizedString;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Charge
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final String CHARGE_TYPE_DELIVERY = "delivery";
    public static final String CHARGE_TYPE_DISCOUNT = "discount";
    public static final String CHARGE_TYPE_TAX = "tax";
    public static final String CHARGE_TYPE_SERVICE = "service";
    public static final String CHARGE_TYPE_TIP = "tip";
    public static final Set<String> ALL_CHARGE_TYPES = new HashSet<String>(Arrays.asList("delivery", "discount", "tax", "service", "tip"));
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String id;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public LocalizedString title = LocalizedString.empty;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public LocalizedString description = LocalizedString.empty;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Condition displayCondition;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Condition condition;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Operator operator;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String state = "operational";
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Boolean mandatory = Boolean.FALSE;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Map<String, String> properties = new LinkedHashMap<String, String>();

    public Charge() {
    }

    public Charge(String type, String id, LocalizedString title, LocalizedString description, Condition displayCondition, Condition condition, Operator operator, String state, Boolean mandatory, Map<String, String> properties) {
        this.type = type;
        this.id = id;
        this.title = title;
        this.description = description;
        this.displayCondition = displayCondition;
        this.condition = condition;
        this.operator = operator;
        this.state = state;
        this.mandatory = mandatory;
        this.properties = properties;
    }

    public Charge clone() {
        return new Charge(this.type, this.id, this.title != null ? this.title.clone() : null, this.description != null ? this.description.clone() : null, this.displayCondition != null ? this.displayCondition.clone() : null, this.condition != null ? this.condition.clone() : null, this.operator != null ? (Operator)this.operator.clone() : null, this.state, this.mandatory, (Map<String, String>)(this.properties != null ? new LinkedHashMap<String, String>(this.properties) : null));
    }

    public static List<Charge> clone(List<Charge> charges) {
        if (charges == null) {
            return null;
        }
        LinkedList<Charge> cloned = new LinkedList<Charge>();
        for (Charge charge : charges) {
            cloned.add(charge != null ? charge.clone() : null);
        }
        return cloned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Charge charge = (Charge)o;
        return Objects.equals(this.type, charge.type) && Objects.equals(this.id, charge.id) && Objects.equals(this.title, charge.title) && Objects.equals(this.description, charge.description) && Objects.equals(this.displayCondition, charge.displayCondition) && Objects.equals(this.condition, charge.condition) && Objects.equals(this.operator, charge.operator) && Objects.equals(this.state, charge.state) && Objects.equals(this.mandatory, charge.mandatory) && Objects.equals(this.properties, charge.properties);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.title, this.description, this.displayCondition, this.condition, this.operator, this.state, this.mandatory, this.properties);
    }

    public String toString() {
        return "Charge{type='" + this.type + '\'' + ", id='" + this.id + '\'' + ", title=" + this.title + ", description=" + this.description + ", displayCondition=" + this.displayCondition + ", condition=" + this.condition + ", operator=" + this.operator + ", state='" + this.state + '\'' + ", mandatory=" + this.mandatory + ", properties=" + this.properties + '}';
    }
}

