/*
 * Decompiled with CFR 0.152.
 */
package com.toorder.bean;

import com.genorder.bean.GeneralOrder;
import com.genorder.bean.OrderItem;
import com.toorder.bean.OrdersListFromToOrder;
import com.toorder.bean.ToOrderHeader;
import com.toorder.bean.ToOrderHeaderShema;
import com.toorder.bean.ToOrderItem;
import com.toorder.bean.ToOrderItemSchema;
import com.toorder.resources.DBConnector;
import com.toorder.resources.DBFuncs;
import com.toorder.resources.ToOrderFormatUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ToOrderOrder {
    private String toorder_id;
    private String toorderRestID;
    private ToOrderHeader toord_header;
    private List<ToOrderItem> toord_items;

    public ToOrderOrder() {
    }

    public ToOrderOrder(GeneralOrder gen_ord) throws Exception {
        this.toorder_id = this.getOrderId();
        gen_ord.setOrder_id(this.toorder_id);
        this.toorderRestID = gen_ord.getOrder_rest().getRest_local_id();
        this.toord_header = new ToOrderHeader(gen_ord);
        ArrayList<ToOrderItem> items_list = new ArrayList<ToOrderItem>();
        boolean mainIsVirt = false;
        for (OrderItem gen_order_item : gen_ord.getOrder_items()) {
            if (gen_order_item.getItem_pos_id().contains("\u05d5\u05d9\u05e8\u05d8\u05d5\u05d0\u05dc\u05d9")) continue;
            String itemLevel = String.valueOf(gen_order_item.getItem_level());
            String itemPOSCode = gen_order_item.getItem_pos_id() != "" ? gen_order_item.getItem_pos_id() : "0-" + gen_order_item.getItem_source_id();
            String itemName = ToOrderFormatUtils.frmToMSMString(gen_order_item.getItem_name());
            String itemPrice = gen_order_item.getItem_price();
            String itemQty = gen_order_item.getItem_qty();
            String itemComment = ToOrderFormatUtils.frmToMSMString(gen_order_item.getItem_comment());
            ToOrderItem toord_item = new ToOrderItem(itemLevel, itemPOSCode, itemName, itemPrice, itemQty);
            items_list.add(toord_item);
            if (itemComment.length() <= 1) continue;
            itemLevel = "1";
            itemPOSCode = itemPOSCode + "-C";
            itemName = itemComment;
            itemPrice = "0.00";
            itemQty = "1.00";
            ToOrderItem toord_comment = new ToOrderItem(itemLevel, itemPOSCode, itemName, itemPrice, itemQty);
            items_list.add(toord_comment);
        }
        this.toord_items = items_list;
    }

    public ToOrderOrder(OrdersListFromToOrder.Order msmord) {
        String[] msmItmArr;
        this.toorder_id = msmord.orderNumber;
        this.toorderRestID = "";
        ToOrderHeaderShema tohdrshem = new ToOrderHeaderShema();
        tohdrshem.setHeader_record(msmord.orderHeader);
        this.toord_header = new ToOrderHeader(tohdrshem);
        ArrayList<ToOrderItem> items_list = new ArrayList<ToOrderItem>();
        String itmStr = msmord.orderContent.substring(0, msmord.orderContent.indexOf("CS||"));
        for (String strItm : msmItmArr = itmStr.split("[\\r\\n]+")) {
            ToOrderItemSchema toOrdItmShema = new ToOrderItemSchema();
            if (!strItm.contains("||")) continue;
            String[] itmrec = strItm.split("[||]+");
            toOrdItmShema.setItem_record(itmrec[1]);
            items_list.add(new ToOrderItem(toOrdItmShema));
        }
        this.toord_items = items_list;
    }

    public Map mapToOrderToGlobal(String toOrderID, String toorderRestID, ToOrderHeader toord_header, List<ToOrderItem> toord_items) {
        LinkedHashMap<String, String> toorder_map = new LinkedHashMap<String, String>();
        ToOrderHeaderShema tord_hdr_schema = new ToOrderHeaderShema(toord_header);
        toorder_map.put("^TMPORD(" + toOrderID + ")", "\"" + tord_hdr_schema.getHeader_record() + "\"");
        int num = 0;
        for (ToOrderItem itm : toord_items) {
            ToOrderItemSchema tord_itm_schema = new ToOrderItemSchema(itm);
            toorder_map.put("^TMPORD(" + toOrderID + "," + ++num + ")", "\"" + tord_itm_schema.getItem_record() + "\"");
        }
        toorder_map.put("^TMPORD(" + toOrderID + "," + "\"MSD\")", toorderRestID);
        return toorder_map;
    }

    public ToOrderHeader getToord_header() {
        return this.toord_header;
    }

    public void setToord_header(ToOrderHeader toord_header) {
        this.toord_header = toord_header;
    }

    public List<ToOrderItem> getToord_items() {
        return this.toord_items;
    }

    public void setToord_items(List<ToOrderItem> toord_items) {
        this.toord_items = toord_items;
    }

    public String getToorder_id() {
        return this.toorder_id;
    }

    public void setToorder_id(String toorder_id) {
        this.toorder_id = toorder_id;
    }

    public String getToorderRestID() {
        return this.toorderRestID;
    }

    public void setToorderRestID(String toorderRestID) {
        this.toorderRestID = toorderRestID;
    }

    public String getToOrderRestCode(String SourceRestCod) throws Exception {
        String resp = "";
        DBConnector dbc = new DBConnector();
        LinkedHashMap global_map = new LinkedHashMap();
        resp = dbc.execute("W $G(^[$$^W3MAIN]W3SOR2M(\"" + SourceRestCod + "\")) ", global_map);
        if (resp.equals("[]")) {
            throw new Exception("Restaurant not connected to POS DB");
        }
        return resp;
    }

    public String getToOrderRestCodeV3(String SourceRestCod) throws Exception {
        String resp = "";
        DBConnector dbc = new DBConnector();
        LinkedHashMap global_map = new LinkedHashMap();
        resp = dbc.execute("W $G(^[$$^W3MAIN]W3SOR2MV3(\"" + SourceRestCod + "\")) ", global_map);
        if (resp.equals("[]")) {
            throw new Exception("Restaurant not connected to POS DB");
        }
        return resp;
    }

    private String getOrderId() throws Exception {
        DBConnector dbc = new DBConnector();
        LinkedHashMap global_map = new LinkedHashMap();
        String order_id = dbc.execute("W $$^%W1SsID(\"SeferHaOchel\")", global_map);
        return order_id;
    }

    public void saveToDB() throws Exception {
        String dbresp = DBFuncs.saveOrderToDB(this);
    }
}

