/*
 * Decompiled with CFR 0.152.
 */
package com.wix.restaurants.availability;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Date
implements Serializable,
Cloneable,
Comparable<Date> {
    private static final long serialVersionUID = 1L;
    private static final Pattern serializedPattern = Pattern.compile("^(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d) (\\d\\d):(\\d\\d)$");
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer year;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer month;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer day;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer hour;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer minute;

    public Date(Integer year, Integer month, Integer day, Integer hour, Integer minute) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
    }

    public Date(Calendar cal) {
        this(cal.get(1), 1 + cal.get(2) - 0, cal.get(5), cal.get(11), cal.get(12));
    }

    public Date() {
    }

    public Object clone() {
        return new Date(this.year, this.month, this.day, this.hour, this.minute);
    }

    public Calendar calendar(TimeZone tz) {
        Calendar cal = Calendar.getInstance(tz);
        cal.clear();
        cal.set(this.year, 0 + this.month - 1, this.day, this.hour, this.minute);
        return cal;
    }

    public String toString() {
        return String.format("%04d-%02d-%02d %02d:%02d", this.year, this.month, this.day, this.hour, this.minute);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.day == null ? 0 : this.day.hashCode());
        result2 = 31 * result2 + (this.hour == null ? 0 : this.hour.hashCode());
        result2 = 31 * result2 + (this.minute == null ? 0 : this.minute.hashCode());
        result2 = 31 * result2 + (this.month == null ? 0 : this.month.hashCode());
        result2 = 31 * result2 + (this.year == null ? 0 : this.year.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((Date)obj) == 0;
    }

    private static int compare(Integer int1, Integer int2) {
        if (int1 != null) {
            return int2 != null ? int1.compareTo(int2) : 1;
        }
        return int2 != null ? -1 : 0;
    }

    public static int compare(Date date1, Date date2) {
        if (date1 == null) {
            return date2 == null ? 0 : 1;
        }
        if (date2 == null) {
            return -1;
        }
        int result2 = Date.compare(date1.year, date2.year);
        if (result2 == 0 && (result2 = Date.compare(date1.month, date2.month)) == 0 && (result2 = Date.compare(date1.day, date2.day)) == 0 && (result2 = Date.compare(date1.hour, date2.hour)) == 0) {
            result2 = Date.compare(date1.minute, date2.minute);
        }
        return result2;
    }

    public static Date parse(String str) {
        Matcher matcher = serializedPattern.matcher(str);
        if (matcher.matches()) {
            return new Date(Integer.valueOf(matcher.group(1)), Integer.valueOf(matcher.group(2)), Integer.valueOf(matcher.group(3)), Integer.valueOf(matcher.group(4)), Integer.valueOf(matcher.group(5)));
        }
        throw new IllegalArgumentException("Invalid date format: " + str);
    }

    @Override
    public int compareTo(Date other) {
        return Date.compare(this, other);
    }
}

