/*
 * Decompiled with CFR 0.152.
 */
package com.wix.restaurants.availability;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.wix.restaurants.availability.Date;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DateTimeWindow
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final String REASON_TEMPORARY = "temporary";
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Date start;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Date end;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean available;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String reason;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Map<String, String> comment = new LinkedHashMap<String, String>();

    public DateTimeWindow(Date start, Date end, Boolean available, String reason, Map<String, String> comment) {
        this.start = start;
        this.end = end;
        this.available = available;
        this.reason = reason;
        this.comment = comment;
    }

    public static DateTimeWindow create(Calendar start, Boolean available) {
        Calendar end = (Calendar)start.clone();
        end.add(12, 1);
        return new DateTimeWindow(start, end, available);
    }

    public DateTimeWindow(Date start, Date end, Boolean available) {
        this(start, end, available, null, new HashMap<String, String>());
    }

    public DateTimeWindow(Calendar start, Calendar end, Boolean available) {
        this(new Date(start), new Date(end), available);
    }

    public DateTimeWindow() {
    }

    public DateTimeWindow clone() {
        return new DateTimeWindow(this.start != null ? (Date)this.start.clone() : null, this.end != null ? (Date)this.end.clone() : null, this.available, this.reason, (Map<String, String>)(this.comment != null ? new HashMap<String, String>(this.comment) : null));
    }

    public static List<DateTimeWindow> clone(List<DateTimeWindow> windows) {
        if (windows == null) {
            return null;
        }
        ArrayList<DateTimeWindow> cloned = new ArrayList<DateTimeWindow>(windows.size());
        for (DateTimeWindow window : windows) {
            cloned.add(window != null ? window.clone() : null);
        }
        return cloned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateTimeWindow that = (DateTimeWindow)o;
        if (this.start != null ? !this.start.equals(that.start) : that.start != null) {
            return false;
        }
        if (this.end != null ? !this.end.equals(that.end) : that.end != null) {
            return false;
        }
        if (this.available != null ? !this.available.equals(that.available) : that.available != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        return this.comment != null ? this.comment.equals(that.comment) : that.comment == null;
    }

    public int hashCode() {
        int result2 = this.start != null ? this.start.hashCode() : 0;
        result2 = 31 * result2 + (this.end != null ? this.end.hashCode() : 0);
        result2 = 31 * result2 + (this.available != null ? this.available.hashCode() : 0);
        result2 = 31 * result2 + (this.reason != null ? this.reason.hashCode() : 0);
        result2 = 31 * result2 + (this.comment != null ? this.comment.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "DateTimeWindow{start=" + this.start + ", end=" + this.end + ", available=" + this.available + ", reason='" + this.reason + '\'' + ", comment=" + this.comment + '}';
    }

    public Calendar start(TimeZone tz) {
        return this.start != null ? this.start.calendar(tz) : null;
    }

    public Calendar end(TimeZone tz) {
        return this.end != null ? this.end.calendar(tz) : null;
    }
}

