/*
 * Decompiled with CFR 0.152.
 */
package com.wix.restaurants.notifications;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.openrest.olo.notifications.FeedbackNotification;
import com.openrest.olo.notifications.OfflineNotification;
import com.openrest.olo.notifications.SubscriptionNotification;
import com.wix.restaurants.notifications.UpdatedOrganizationNotification;
import com.wix.restaurants.orders.notifications.AcceptedOrderNotification;
import com.wix.restaurants.orders.notifications.CanceledOrderNotification;
import com.wix.restaurants.orders.notifications.DelayedOrderNotification;
import com.wix.restaurants.orders.notifications.LowStockNotification;
import com.wix.restaurants.orders.notifications.NewOrderNotification;
import com.wix.restaurants.orders.notifications.PosErrorNotification;
import com.wix.restaurants.orders.notifications.SubmittedOrderNotification;
import com.wix.restaurants.orders.notifications.UpdatedOrderNotification;
import com.wix.restaurants.reservations.notifications.UpdatedReservationNotification;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=NewOrderNotification.class, name="new_order"), @JsonSubTypes.Type(value=SubmittedOrderNotification.class, name="submitted_order"), @JsonSubTypes.Type(value=DelayedOrderNotification.class, name="delayed_order"), @JsonSubTypes.Type(value=AcceptedOrderNotification.class, name="accepted_order"), @JsonSubTypes.Type(value=CanceledOrderNotification.class, name="canceled_order"), @JsonSubTypes.Type(value=OfflineNotification.class, name="offline"), @JsonSubTypes.Type(value=PosErrorNotification.class, name="pos_error"), @JsonSubTypes.Type(value=FeedbackNotification.class, name="feedback"), @JsonSubTypes.Type(value=SubscriptionNotification.class, name="subscription"), @JsonSubTypes.Type(value=LowStockNotification.class, name="low_stock"), @JsonSubTypes.Type(value=UpdatedReservationNotification.class, name="updated_reservation"), @JsonSubTypes.Type(value=UpdatedOrganizationNotification.class, name="updated_organization"), @JsonSubTypes.Type(value=UpdatedOrderNotification.class, name="updated_order")})
public abstract class Notification
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String channelId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String channelParam;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String comment;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String state = "operational";

    public Notification() {
    }

    public Notification(String channelId, String channelParam, String comment, String state) {
        this.channelId = channelId;
        this.channelParam = channelParam;
        this.comment = comment;
        this.state = state;
    }

    public abstract Notification clone();

    public static List<Notification> clone(List<Notification> notifications) {
        if (notifications == null) {
            return null;
        }
        LinkedList<Notification> cloned = new LinkedList<Notification>();
        for (Notification notification : notifications) {
            cloned.add(notification != null ? notification.clone() : null);
        }
        return cloned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification that = (Notification)o;
        return Objects.equals(this.channelId, that.channelId) && Objects.equals(this.channelParam, that.channelParam) && Objects.equals(this.comment, that.comment) && Objects.equals(this.state, that.state);
    }

    public int hashCode() {
        return Objects.hash(this.channelId, this.channelParam, this.comment, this.state);
    }
}

