/*
 * Decompiled with CFR 0.152.
 */
package com.wix.restaurants.payments;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.wix.pay.smaug.client.model.CreditCardToken;
import com.wix.restaurants.payments.Payment;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CreditcardPayment
extends Payment {
    public static final String TYPE = "credit";
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String collectionMethod;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CreditCardToken cardToken;

    public CreditcardPayment() {
    }

    public CreditcardPayment(Integer amount, Map<String, String> externalIds, String collectionMethod, CreditCardToken cardToken) {
        super(amount, externalIds);
        this.collectionMethod = collectionMethod;
        this.cardToken = cardToken;
    }

    @Override
    public CreditcardPayment clone() {
        return this.cloneImpl();
    }

    @Override
    protected CreditcardPayment cloneImpl() {
        return new CreditcardPayment(this.amount, this.externalIds != null ? new LinkedHashMap<String, String>(this.externalIds) : null, this.collectionMethod, this.cardToken);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CreditcardPayment that = (CreditcardPayment)o;
        return Objects.equals(this.collectionMethod, that.collectionMethod) && Objects.equals(this.cardToken, that.cardToken);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.collectionMethod, this.cardToken);
    }
}

