/*
 * Decompiled with CFR 0.152.
 */
package com.frsvision.resources.net;

import com.frsvision.resources.net.SocketsClient;
import com.frsvision.resources.net.SocketsClientConnectException;
import com.frsvision.resources.net.SocketsClientConnectTimeoutException;
import com.frsvision.resources.net.SocketsClientReadException;
import com.frsvision.resources.net.SocketsClientReadTimeoutException;
import com.frsvision.resources.net.SocketsClientWriteException;
import com.frsvision.resources.net.SocketsClientWriteTimeoutException;
import com.google.common.primitives.Bytes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;
import scala.Option;
import scala.concurrent.duration.Duration;

public class DirectSocketsClient
implements SocketsClient {
    private final int maxResponseSize;

    public DirectSocketsClient(int maxResponseSize) {
        this.maxResponseSize = maxResponseSize;
    }

    private static InetAddress resolve(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new SocketsClientConnectException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String send(String host, int port, Option<Duration> connectTimeout, String data, Option<Duration> writeTimeout, Option<Duration> readTimeout, Option<Duration> readIdleTimeout, String endMarker, int maxResponseSize) {
        int responseSize;
        byte[] responseData;
        block25: {
            maxResponseSize = Math.min(maxResponseSize, this.maxResponseSize);
            byte[] endMarkerBytes = endMarker != null ? Base64.decodeBase64((byte[])endMarker.getBytes()) : null;
            responseData = null;
            responseSize = 0;
            InetSocketAddress destination = new InetSocketAddress(DirectSocketsClient.resolve(host), port);
            Socket socket = new Socket();
            try {
                try {
                    socket.setTcpNoDelay(true);
                    if (connectTimeout.isDefined()) {
                        socket.connect(destination, (int)((Duration)connectTimeout.get()).toMillis());
                    } else {
                        socket.connect(destination);
                    }
                }
                catch (SocketTimeoutException e) {
                    throw new SocketsClientConnectTimeoutException("connect timeout exceeded: " + connectTimeout, e);
                }
                catch (IOException e) {
                    throw new SocketsClientConnectException(e.getMessage(), e);
                }
                if (data != null && data.length() > 0) {
                    try {
                        if (writeTimeout.isDefined()) {
                            socket.setSoTimeout((int)((Duration)writeTimeout.get()).toMillis());
                        }
                        byte[] requestData = Base64.decodeBase64((byte[])data.getBytes());
                        OutputStream os = socket.getOutputStream();
                        os.write(requestData);
                        os.flush();
                    }
                    catch (SocketTimeoutException e) {
                        throw new SocketsClientWriteTimeoutException("write timeout exceeded: " + writeTimeout, e);
                    }
                    catch (IOException e) {
                        throw new SocketsClientWriteException(e.getMessage(), e);
                    }
                }
                try {
                    if (maxResponseSize <= 0) break block25;
                    long readEnd = System.currentTimeMillis() + (readTimeout.isDefined() && ((Duration)readTimeout.get()).toMillis() > 0L ? ((Duration)readTimeout.get()).toMillis() : Integer.MAX_VALUE);
                    responseData = new byte[maxResponseSize];
                    InputStream is = socket.getInputStream();
                    do {
                        byte[] readData;
                        int index;
                        int numRead;
                        block26: {
                            long now;
                            if ((now = System.currentTimeMillis()) >= readEnd) {
                                throw new SocketsClientReadTimeoutException("readTimeout exceeded: " + readTimeout, null);
                            }
                            long actualReadIdleTimeout = readIdleTimeout.isDefined() ? ((Duration)readIdleTimeout.get()).toMillis() : Integer.MAX_VALUE;
                            socket.setSoTimeout(Math.min((int)actualReadIdleTimeout, (int)(readEnd - now)));
                            try {
                                numRead = is.read(responseData, responseSize, responseData.length - responseSize);
                                if (numRead != -1) break block26;
                                break;
                            }
                            catch (SocketTimeoutException e) {
                                if (System.currentTimeMillis() > readEnd) {
                                    throw new SocketsClientReadTimeoutException("readTimeout exceeded: " + readTimeout, null);
                                }
                                break;
                            }
                        }
                        if (endMarkerBytes == null || (index = Bytes.indexOf((byte[])(readData = Arrays.copyOfRange(responseData, 0, responseSize += numRead)), (byte[])endMarkerBytes)) < 0) continue;
                        responseSize = index + endMarkerBytes.length;
                        break;
                    } while (responseSize != responseData.length);
                }
                catch (IOException e) {
                    throw new SocketsClientReadException(e.getMessage(), e);
                }
            }
            finally {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (responseData == null || responseSize <= 0) {
            return null;
        }
        return new String(Base64.encodeBase64((byte[])Arrays.copyOfRange(responseData, 0, responseSize)));
    }
}

