/*
 * Decompiled with CFR 0.152.
 */
package com.frsvision.resources.net;

import com.frsvision.resources.net.FrsvisionClientPacketParser;
import com.frsvision.resources.net.FrsvisionServerPacketParser;
import com.frsvision.resources.net.Packets;
import com.frsvision.resources.net.SocketsClient;
import com.frsvision.resources.pos.Error;
import com.frsvision.resources.pos.FrsvisionException;
import com.frsvision.resources.pos.Strings;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import scala.Option;
import scala.concurrent.duration.Duration;

public class FrsvisionProtocol {
    SocketsClient sockets;
    private final String host;
    private final Integer port;
    String key;
    String iv;
    Option<Duration> connectTimeout = null;
    Option<Duration> writeTimeout = null;
    Option<Duration> readTimeout = null;
    Option<Duration> readIdleTimeout = null;

    public FrsvisionProtocol(SocketsClient sockets, String host, Integer port, String key, String iv, Option<Duration> connectTimeout, Option<Duration> writeTimeout, Option<Duration> readTimeout, Option<Duration> readIdleTimeout) {
        this.sockets = sockets;
        this.host = host;
        this.port = port;
        this.key = key;
        this.iv = iv;
        this.connectTimeout = connectTimeout;
        this.writeTimeout = writeTimeout;
        this.readTimeout = readTimeout;
        this.readIdleTimeout = readIdleTimeout;
    }

    public String send(String data) throws UnsupportedEncodingException, FrsvisionException {
        FrsvisionClientPacketParser clientPacketParser = new FrsvisionClientPacketParser(this.key, this.iv);
        FrsvisionServerPacketParser serverPacketParser = new FrsvisionServerPacketParser();
        byte[] clientPacket = clientPacketParser.toPacket(data);
        String requestData = new String(Base64.encodeBase64((byte[])clientPacket), "UTF-8");
        String responseData = "";
        String endMarker = new String(Base64.encodeBase64((byte[])Strings.bytify(Packets.endMarker, "UTF-8")));
        responseData = this.sockets.send(this.host, this.port, this.connectTimeout, requestData, this.writeTimeout, this.readTimeout, this.readIdleTimeout, endMarker, 10240);
        if (responseData.isEmpty()) {
            throw new FrsvisionException(new Error("protocol", "Response data is empty"));
        }
        byte[] serverPacket = Base64.decodeBase64((byte[])responseData.getBytes());
        return serverPacketParser.fromPacket(serverPacket);
    }
}

