/*
 * Decompiled with CFR 0.152.
 */
package com.openrest.resources;

import com.openrest.order.beans.v3.Data;
import com.openrest.order.beans.v3.Root;
import com.openrest.resources.ProcessSoOrderV3;
import com.wix.restaurants.json.Json;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.util.io.pem.PemReader;

public class OrderWatcher {
    Map<WatchKey, Path> keys;
    WatchService watcher;
    Path dir = Paths.get("/pos/tmp/income/", new String[0]);
    static String POSID = "il.co.elpos";
    static PublicKey publicKey;

    public OrderWatcher() {
        publicKey = this.getPublicKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PublicKey getPublicKey() {
        try {
            byte[] rsaPublicKey = new PemReader((Reader)new FileReader("/pos/tmp/public.pem")).readPemObject().getContent();
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(rsaPublicKey);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PublicKey publicKey = OrderWatcher.publicKey = kf.generatePublic(keySpec);
            return publicKey;
        }
        catch (Exception exception) {}
        finally {
            return publicKey;
        }
    }

    void processJws(String jwsString) throws IOException, Exception {
        Jws jws = Jwts.parserBuilder().setSigningKey((Key)publicKey).build().parseClaimsJws(jwsString);
        String jsonData = (String)((Claims)jws.getBody()).get("data", String.class);
        Root root = (Root)Json.parse((String)jsonData, Root.class);
        Data data = (Data)Json.parse((String)root.getData(), Data.class);
        String restId = data.getCreatedEvent().getEntity().getRestaurantId();
        String orderid = data.getCreatedEvent().getEntity().getId();
        ProcessSoOrderV3 procord = new ProcessSoOrderV3();
        procord.processOrder(data, restId, orderid);
    }

    private void dirWatcher() throws IOException {
        WatchKey key;
        boolean valid;
        this.watcher = FileSystems.getDefault().newWatchService();
        try {
            WatchKey watchKey = this.dir.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (IOException x) {
            System.err.println(x);
        }
        do {
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException x) {
                return;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent<?> ev = event;
                Path filename = (Path)ev.context();
                try {
                    Path child = this.dir.resolve(filename);
                    String fileContent = "";
                    byte[] bytes = Files.readAllBytes(child);
                    fileContent = new String(bytes);
                    this.processJws(fileContent);
                    Files.move(child, Paths.get("/pos/tmp/done/", new String[0]), new CopyOption[0]);
                }
                catch (Exception x) {
                    System.err.println(x);
                }
            }
        } while (valid = key.reset());
    }

    static void usage() {
        System.err.println("usage: java WatchDir [-r] dir");
        System.exit(-1);
    }

    public static void main(String[] args) {
        try {
            new OrderWatcher().dirWatcher();
        }
        catch (IOException ex) {
            Logger.getLogger(OrderWatcher.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

