/*
 * Decompiled with CFR 0.152.
 */
package com.toorder.resources;

import com.genorder.resources.GetSoOrderDetailts;
import com.toorder.resources.DBConnector;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ToOrderFormatUtils {
    public static String frmString(String tmp) {
        if (tmp == null) {
            tmp = "";
        }
        return tmp;
    }

    public static String frmToMSMString(String tmp) {
        if (tmp == null || tmp.trim().length() == 0) {
            tmp = "";
            return tmp;
        }
        tmp = ToOrderFormatUtils.eng2Upper(tmp);
        tmp = tmp.replace("\"", "''");
        tmp = tmp.replace("~", "");
        tmp = tmp.replace("\r", "");
        tmp = tmp.replace("`", "'");
        tmp = tmp.replace("'", "'");
        tmp = tmp.replace("\n", "");
        tmp = tmp.replace("\t", "");
        tmp = tmp.replace("(", " ) ");
        tmp = tmp.replace(")", " ) ");
        tmp = tmp.replace(",", " , ");
        tmp = tmp.replace(":", " : ");
        tmp = ToOrderFormatUtils.hebrew_reverce(tmp);
        return tmp;
    }

    public static String frmMSMStoUTFString(String tmp) {
        if (tmp == null) {
            tmp = "";
            return tmp;
        }
        tmp = ToOrderFormatUtils.hebrew_reverce7bit(tmp);
        tmp = ToOrderFormatUtils.heb7bit2UTF(tmp);
        return tmp;
    }

    public static String frmAgorotToNis(String tmp) {
        if (tmp == null) {
            tmp = "0";
        }
        BigDecimal bd = new BigDecimal(tmp);
        return bd.movePointLeft(2).toString();
    }

    public static String frmIntToDecimal(String tmp) {
        if (tmp == null || tmp.length() == 0) {
            tmp = "0.00";
        }
        if (tmp.contains(".")) {
            return tmp;
        }
        tmp = String.valueOf(Integer.valueOf(tmp) * 100);
        tmp = ToOrderFormatUtils.frmAgorotToNis(tmp);
        return tmp;
    }

    public static String frmDateTime(Date tmp, String frmt) {
        Date dt = new Date();
        if (tmp == null) {
            tmp = dt;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(frmt);
        return sdf.format(tmp).toString();
    }

    public static String frmPhone(String phone) {
        if (phone == null) {
            return "";
        }
        if (phone.contains("-")) {
            return phone;
        }
        if (phone.startsWith("+") && phone.length() > 8) {
            phone = phone.substring(4);
        }
        if (phone.length() > 8) {
            phone = String.format("%10s", phone).replace(' ', '0');
            phone = phone.substring(0, 3) + "-" + phone.substring(3);
        } else {
            phone = String.format("%9s", phone).replace(' ', '0');
            phone = phone.substring(0, 2) + "-" + phone.substring(2);
        }
        return phone;
    }

    public static String eng2Upper(String text) {
        if (text == null) {
            return "";
        }
        StringBuilder sbuf = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            int c = text.charAt(i);
            if (c > 95 && c < 123) {
                c -= 32;
            }
            sbuf.append((char)c);
        }
        return sbuf.toString();
    }

    public static String unicodeToWindowsHebrew(String text) throws UnsupportedEncodingException {
        byte[] winhebchars = text.getBytes(Charset.forName("ISO-8859-8"));
        String str = new String(winhebchars, Charset.forName("ISO-8859-8"));
        return str;
    }

    public static String heb7bit2UTF(String text) {
        char[] winhebchars = new char[text.length()];
        for (int i = 0; i < text.length(); ++i) {
            int c = text.charAt(i);
            if (c >= 96 && c < 127) {
                c += 1392;
            }
            winhebchars[i] = (char)c;
        }
        String str = new String(winhebchars);
        return str;
    }

    public static String hebrew_reverce(String text) {
        List<Object> lststr = new LinkedList();
        String[] arrstr = text.split(" ");
        lststr = Arrays.asList(arrstr);
        int i = 0;
        boolean hebrewContent = false;
        String result = "";
        if (text.length() == 0) {
            return text;
        }
        for (String string : lststr) {
            if (ToOrderFormatUtils.containHebrewChars(string)) {
                lststr.set(i, ToOrderFormatUtils.reverseWordAdv(string));
                hebrewContent = true;
            }
            ++i;
        }
        if (lststr.size() > 1 && hebrewContent) {
            for (int revcount = lststr.size() - 1; revcount >= 0; --revcount) {
                result = result + (String)lststr.get(revcount) + " ";
            }
        } else if (lststr.size() > 1 && !hebrewContent) {
            for (String string : lststr) {
                result = result + string + " ";
            }
        } else {
            result = result + (String)lststr.get(0);
        }
        return result;
    }

    public static String hebrew_reverce7bit(String text) {
        List<Object> lststr = new LinkedList();
        String[] arrstr = text.split(" ");
        lststr = Arrays.asList(arrstr);
        int i = 0;
        boolean hebrewContent = false;
        String result = "";
        if (text.length() == 0) {
            return text;
        }
        for (String string : lststr) {
            if (ToOrderFormatUtils.containHebrewChars7bit(string)) {
                lststr.set(i, ToOrderFormatUtils.reverseWordAdvHeb7bit(string));
                hebrewContent = true;
            }
            ++i;
        }
        if (lststr.size() > 1 && hebrewContent) {
            for (int revcount = lststr.size() - 1; revcount >= 0; --revcount) {
                result = result + (String)lststr.get(revcount) + " ";
            }
        } else if (lststr.size() > 1 && !hebrewContent) {
            for (String string : lststr) {
                result = result + string + " ";
            }
        } else {
            result = result + (String)lststr.get(0);
        }
        return result;
    }

    public static boolean isHebrewChar(char c) {
        return c > '\u05cf' && c < '\u05f4' || c > '\u00df' && c < '\u0100' || c == '\'' || c == '`';
    }

    public static boolean isHebrewChar7bit(char c) {
        return c > '`' && c < '\u007f' || c == '\'' || c == '`';
    }

    public static String reverseWord(String str) {
        StringBuilder sbuf = new StringBuilder(str.length());
        for (int i = str.length() - 1; i >= 0; --i) {
            sbuf.append(str.charAt(i));
        }
        return sbuf.toString();
    }

    public static String reverseWordAdv(String str) {
        StringBuilder sbuf = new StringBuilder(str.length());
        StringBuilder sbufNoHeb = new StringBuilder(str.length());
        StringBuilder result = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            if (ToOrderFormatUtils.isHebrewChar(str.charAt(i))) {
                sbuf.append(str.charAt(i));
                sbufNoHeb.append('\t');
                continue;
            }
            sbufNoHeb.append(str.charAt(i));
        }
        int j = sbuf.length() - 1;
        for (int i = 0; i < sbufNoHeb.length(); ++i) {
            if (sbufNoHeb.charAt(i) == '\t') {
                char hebchar = sbuf.charAt(j);
                result.insert(i, hebchar);
                --j;
                continue;
            }
            result.insert(i, sbufNoHeb.charAt(i));
        }
        return result.toString();
    }

    public static String reverseWordAdvHeb7bit(String str) {
        StringBuilder sbuf = new StringBuilder(str.length());
        StringBuilder sbufNoHeb = new StringBuilder(str.length());
        StringBuilder result = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            if (ToOrderFormatUtils.isHebrewChar7bit(str.charAt(i))) {
                sbuf.append(str.charAt(i));
                sbufNoHeb.append('\t');
                continue;
            }
            sbufNoHeb.append(str.charAt(i));
        }
        int j = sbuf.length() - 1;
        for (int i = 0; i < sbufNoHeb.length(); ++i) {
            if (sbufNoHeb.charAt(i) == '\t') {
                char hebchar = sbuf.charAt(j);
                result.insert(i, hebchar);
                --j;
                continue;
            }
            result.insert(i, sbufNoHeb.charAt(i));
        }
        return result.toString();
    }

    public static boolean containHebrewChars(String str) {
        boolean flag = false;
        for (int i = str.length() - 1; i >= 0 && !flag; --i) {
            if (!ToOrderFormatUtils.isHebrewChar(str.charAt(i))) continue;
            flag = true;
        }
        return flag;
    }

    public static boolean containHebrewChars7bit(String str) {
        boolean flag = false;
        for (int i = str.length() - 1; i >= 0 && !flag; --i) {
            if (!ToOrderFormatUtils.isHebrewChar7bit(str.charAt(i))) continue;
            flag = true;
        }
        return flag;
    }

    public static String datToMdat(String dat) {
        DBConnector dbc = new DBConnector();
        LinkedHashMap global_map = new LinkedHashMap();
        try {
            String mdat = dbc.execute("W $$^%L1DC(\"" + dat + "\",3)", global_map);
            return mdat;
        }
        catch (Exception ex) {
            Logger.getLogger(GetSoOrderDetailts.class.getName()).log(Level.SEVERE, null, ex);
            return "ERR-GET-MDAT";
        }
    }
}

