/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.internal;

import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;

public class SocketUtils {
    private static Logger log = Logger.getLogger("SocketUtils");
    private static boolean timeoutSupported = true;
    private static boolean isConnectedSupported = true;
    static /* synthetic */ Class class$java$net$Socket;
    static /* synthetic */ Class class$java$net$InetAddress;

    public static Socket createSocket(InetAddress host, int port, int timeout2) throws IOException {
        if (timeout2 == 0 || !timeoutSupported) {
            return new Socket(host, port);
        }
        try {
            Class<?> socketAddress = Class.forName("java.net.SocketAddress");
            Method connectMethod = (class$java$net$Socket == null ? (class$java$net$Socket = SocketUtils.class$("java.net.Socket")) : class$java$net$Socket).getMethod("connect", socketAddress, Integer.TYPE);
            Socket sock = (Socket)(class$java$net$Socket == null ? (class$java$net$Socket = SocketUtils.class$("java.net.Socket")) : class$java$net$Socket).newInstance();
            Class<?> inetSocketAddress = Class.forName("java.net.InetSocketAddress");
            Constructor<?> inetSocketAddressCtr = inetSocketAddress.getConstructor(class$java$net$InetAddress == null ? (class$java$net$InetAddress = SocketUtils.class$("java.net.InetAddress")) : class$java$net$InetAddress, Integer.TYPE);
            Object address = inetSocketAddressCtr.newInstance(host, new Integer(port));
            log.debug("Invoking connect with timeout=" + timeout2);
            connectMethod.invoke((Object)sock, address, new Integer(timeout2));
            log.debug("Connected successfully");
            return sock;
        }
        catch (InvocationTargetException ex) {
            Throwable target = ex.getTargetException();
            if (target instanceof IOException) {
                throw (IOException)target;
            }
            log.debug("Could not use timeout connecting to host (" + ex.toString() + ")");
            timeoutSupported = false;
            return new Socket(host, port);
        }
        catch (Exception ex) {
            log.debug("Could not use timeout connecting to host (" + ex.toString() + ")");
            timeoutSupported = false;
            return new Socket(host, port);
        }
    }

    public static boolean isConnected(Socket sock) throws IOException {
        if (!isConnectedSupported) {
            return true;
        }
        try {
            Method connectedMethod = (class$java$net$Socket == null ? (class$java$net$Socket = SocketUtils.class$("java.net.Socket")) : class$java$net$Socket).getMethod("isConnected", null);
            Boolean result2 = (Boolean)connectedMethod.invoke((Object)sock, (Object[])null);
            return result2;
        }
        catch (InvocationTargetException ex) {
            Throwable target = ex.getTargetException();
            if (target instanceof IOException) {
                throw (IOException)target;
            }
            isConnectedSupported = false;
            log.debug("Could not use Socket.isConnected (" + ex.toString() + ")");
            return true;
        }
        catch (Exception ex) {
            log.debug("Could not use Socket.isConnected (" + ex.toString() + ")");
            isConnectedSupported = false;
            return true;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

