/*
 * Decompiled with CFR 0.152.
 */
package com.openrest.resources;

import com.openrest.order.beans.v3.Data;
import com.openrest.order.beans.v3.Root;
import com.openrest.resources.ProcessSoOrderV3;
import com.wix.restaurants.json.Json;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.util.io.pem.PemReader;

public class OrderWatcher {
    Map<WatchKey, Path> keys;
    WatchService watcher;
    Path dir = Paths.get("/pos/tmp/inprocess/", new String[0]);
    static String POSID = "il.co.elpos";
    static PublicKey publicKey;

    public OrderWatcher() {
        publicKey = this.getPublicKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PublicKey getPublicKey() {
        try {
            byte[] rsaPublicKey = new PemReader(new FileReader("/pos/tmp/public.pem")).readPemObject().getContent();
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(rsaPublicKey);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PublicKey publicKey = OrderWatcher.publicKey = kf.generatePublic(keySpec);
            return publicKey;
        }
        catch (Exception exception) {}
        finally {
            return publicKey;
        }
    }

    void processJws(String jwsString) throws IOException, Exception {
        Jws<Claims> jws = Jwts.parserBuilder().setSigningKey(publicKey).build().parseClaimsJws(jwsString);
        String jsonData = ((Claims)jws.getBody()).get("data", String.class);
        Root root = Json.parse(jsonData, Root.class);
        String restId = "";
        String orderid = "";
        Data data = Json.parse(root.getData(), Data.class);
        if (data.getActionEvent() == null) {
            restId = data.getCreatedEvent().getEntity().getRestaurantId();
            orderid = data.getCreatedEvent().getEntity().getId();
        } else {
            restId = data.getActionEvent().getBody().getOrder().getRestaurantId();
            orderid = data.getEntityId();
        }
        String restOrderFl = "/pos/tmp/decoded/order_v3_" + data.getId() + "_" + restId + "_" + orderid + ".json";
        File fl = new File(restOrderFl);
        if (!fl.exists()) {
            BufferedWriter outputStream2 = new BufferedWriter(new FileWriter(restOrderFl));
            outputStream2.write(jsonData);
            outputStream2.flush();
            outputStream2.close();
            Date eventDate = data.getEventTime();
            Date twoHourBack = new Date(System.currentTimeMillis() - 0x6DDD00L);
            if (eventDate.before(twoHourBack)) {
                System.out.printf("order %s from restautrant %s is two old %s ", orderid, restId, eventDate.toString());
            } else {
                System.out.printf("1 got order %s from restautrant %s ", orderid, restId);
                ProcessSoOrderV3 procord = new ProcessSoOrderV3();
                procord.processOrder(data, restId, orderid);
            }
        }
    }

    private void dirWatcher() throws IOException {
        WatchKey key;
        boolean valid;
        this.watcher = FileSystems.getDefault().newWatchService();
        try {
            WatchKey watchKey = this.dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE);
        }
        catch (IOException x) {
            System.err.println(x);
        }
        do {
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException x) {
                return;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(OrderWatcher.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (kind == StandardWatchEventKinds.OVERFLOW) {
                    System.out.println("Event OVERFLOW happened");
                    continue;
                }
                WatchEvent<?> ev = event;
                Path filename = (Path)ev.context();
                try {
                    Path child = this.dir.resolve(filename);
                    String fileContent = new String(Files.readAllBytes(child), StandardCharsets.UTF_8);
                    this.processJws(fileContent);
                    Files.move(child, Paths.get("/pos/tmp/done/" + filename, new String[0]), new CopyOption[0]);
                }
                catch (Exception x) {
                    System.err.println(x);
                }
            }
        } while (valid = key.reset());
    }

    static void usage() {
        System.err.println("usage: java WatchDir [-r] dir");
        System.exit(-1);
    }

    public static void main(String[] args2) {
        try {
            new OrderWatcher().dirWatcher();
        }
        catch (IOException ex) {
            Logger.getLogger(OrderWatcher.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

