/*
 * Decompiled with CFR 0.152.
 */
package com.openrest.v1_1;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.openrest.v1_1.Stock;
import com.openrest.v1_1.Variation;
import com.wix.restaurants.conditions.Condition;
import com.wix.restaurants.i18n.LocalizedString;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Item
implements Serializable,
Cloneable,
Comparable<Item> {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String id;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public LocalizedString title = LocalizedString.empty;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public LocalizedString description = LocalizedString.empty;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Integer price = 0;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public List<Variation> variations = new LinkedList<Variation>();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Condition displayCondition;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Condition condition;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, String> media = new LinkedHashMap<String, String>();
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Map<String, String> externalIds = new LinkedHashMap<String, String>();
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Set<String> labels = new LinkedHashSet<String>();
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Map<String, String> properties = new LinkedHashMap<String, String>();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Stock stock;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer maxCommentLength;

    public Item(String id, LocalizedString title, LocalizedString description, Integer price, List<Variation> variations, Condition displayCondition, Condition condition, Map<String, String> media, Map<String, String> externalIds, Set<String> labels, Map<String, String> properties, Stock stock, Integer maxCommentLength) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.price = price;
        this.variations = variations;
        this.displayCondition = displayCondition;
        this.condition = condition;
        this.media = media;
        this.externalIds = externalIds;
        this.labels = labels;
        this.properties = properties;
        this.stock = stock;
        this.maxCommentLength = maxCommentLength;
    }

    public Item() {
    }

    public static List<Item> clone(List<Item> items) {
        if (items == null) {
            return null;
        }
        LinkedList<Item> cloned = new LinkedList<Item>();
        for (Item item : items) {
            cloned.add(item != null ? item.clone() : null);
        }
        return cloned;
    }

    public Item clone() {
        return new Item(this.id, this.title != null ? this.title.clone() : null, this.description != null ? this.description.clone() : null, this.price, Variation.clone(this.variations), this.displayCondition != null ? this.displayCondition.clone() : null, this.condition != null ? this.condition.clone() : null, this.media != null ? new LinkedHashMap<String, String>(this.media) : null, this.externalIds != null ? new LinkedHashMap<String, String>(this.externalIds) : null, this.labels != null ? new LinkedHashSet<String>(this.labels) : null, this.properties != null ? new LinkedHashMap<String, String>(this.properties) : null, this.stock, this.maxCommentLength);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item)o;
        return Objects.equals(this.id, item.id) && Objects.equals(this.title, item.title) && Objects.equals(this.description, item.description) && Objects.equals(this.price, item.price) && Objects.equals(this.variations, item.variations) && Objects.equals(this.displayCondition, item.displayCondition) && Objects.equals(this.condition, item.condition) && Objects.equals(this.media, item.media) && Objects.equals(this.externalIds, item.externalIds) && Objects.equals(this.labels, item.labels) && Objects.equals(this.properties, item.properties) && Objects.equals(this.stock, item.stock) && Objects.equals(this.maxCommentLength, item.maxCommentLength);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.description, this.price, this.variations, this.displayCondition, this.condition, this.media, this.externalIds, this.labels, this.properties, this.stock, this.maxCommentLength);
    }

    @Override
    public int compareTo(Item other) {
        return this.id.compareTo(other.id);
    }

    public String toString() {
        return "Item{id='" + this.id + '\'' + ", title=" + this.title + ", description=" + this.description + ", price=" + this.price + ", variations=" + this.variations + ", displayCondition=" + this.displayCondition + ", condition=" + this.condition + ", media=" + this.media + ", externalIds=" + this.externalIds + ", labels=" + this.labels + ", properties=" + this.properties + ", stock=" + this.stock + ", maxCommentLength=" + this.maxCommentLength + '}';
    }
}

