/*
 * Decompiled with CFR 0.152.
 */
package com.openrest.v1_1;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.wix.restaurants.i18n.LocalizedString;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Variation
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public LocalizedString title = LocalizedString.empty;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> itemIds = new LinkedList<String>();
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Integer minNumAllowed = 0;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Integer maxNumAllowed = Integer.MAX_VALUE;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Map<String, Integer> prices = new LinkedHashMap<String, Integer>();
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Set<String> defaults = new LinkedHashSet<String>();
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String displayType = "choice";
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Map<String, String> properties = new LinkedHashMap<String, String>();

    public Variation(LocalizedString title, List<String> itemIds, Integer minNumAllowed, Integer maxNumAllowed, Map<String, Integer> prices, Set<String> defaults, String displayType, Map<String, String> properties) {
        this.title = title;
        this.itemIds = itemIds;
        this.minNumAllowed = minNumAllowed;
        this.maxNumAllowed = maxNumAllowed;
        this.prices = prices;
        this.defaults = defaults;
        this.displayType = displayType;
        this.properties = properties;
    }

    public Variation() {
    }

    public Variation clone() {
        return new Variation(this.title != null ? this.title.clone() : null, this.itemIds != null ? new LinkedList<String>(this.itemIds) : null, this.minNumAllowed, this.maxNumAllowed, this.prices != null ? new LinkedHashMap<String, Integer>(this.prices) : null, this.defaults != null ? new LinkedHashSet<String>(this.defaults) : null, this.displayType, (Map<String, String>)(this.properties != null ? new LinkedHashMap<String, String>(this.properties) : null));
    }

    public static List<Variation> clone(List<Variation> variations) {
        if (variations == null) {
            return null;
        }
        LinkedList<Variation> cloned = new LinkedList<Variation>();
        for (Variation variation : variations) {
            cloned.add(variation != null ? variation.clone() : null);
        }
        return cloned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variation variation = (Variation)o;
        return Objects.equals(this.title, variation.title) && Objects.equals(this.itemIds, variation.itemIds) && Objects.equals(this.minNumAllowed, variation.minNumAllowed) && Objects.equals(this.maxNumAllowed, variation.maxNumAllowed) && Objects.equals(this.prices, variation.prices) && Objects.equals(this.defaults, variation.defaults) && Objects.equals(this.displayType, variation.displayType) && Objects.equals(this.properties, variation.properties);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.itemIds, this.minNumAllowed, this.maxNumAllowed, this.prices, this.defaults, this.displayType, this.properties);
    }
}

