/*
 * Decompiled with CFR 0.152.
 */
package com.wix.restaurants.availability;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Status
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final String STATUS_AVAILABLE = "available";
    public static final String STATUS_UNAVAILABLE = "unavailable";
    public static final String STATUS_UNKNOWN = "unknown";
    public static final Set<String> ALL_STATUSES = new HashSet<String>(Arrays.asList("available", "unavailable"));
    public static final Status UNKNOWN = new Status("unknown", null);
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String status;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long until;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String reason;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Map<String, String> comment = new LinkedHashMap<String, String>();

    public Status(String status, Date until, String reason, Map<String, String> comment) {
        this.status = status;
        this.until = until != null ? Long.valueOf(until.getTime()) : null;
        this.reason = reason;
        this.comment = comment;
    }

    public Status(String status, Date until) {
        this(status, until, null, new HashMap<String, String>());
    }

    public Status() {
    }

    public Object clone() {
        return new Status(this.status, this.until(), this.reason, (Map<String, String>)(this.comment != null ? new LinkedHashMap<String, String>(this.comment) : null));
    }

    public Date until() {
        return this.until != null ? new Date(this.until) : null;
    }

    public boolean available() {
        return STATUS_AVAILABLE.equals(this.status);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.comment == null ? 0 : this.comment.hashCode());
        result2 = 31 * result2 + (this.reason == null ? 0 : this.reason.hashCode());
        result2 = 31 * result2 + (this.status == null ? 0 : this.status.hashCode());
        result2 = 31 * result2 + (this.until == null ? 0 : this.until.hashCode());
        return result2;
    }

    public boolean equalsIgnoreUntil(Status other) {
        if (this.comment == null ? other.comment != null : !this.comment.equals(other.comment)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals(other.reason)) {
            return false;
        }
        return !(this.status == null ? other.status != null : !this.status.equals(other.status));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Status other = (Status)obj;
        if (this.until == null ? other.until != null : !this.until.equals(other.until)) {
            return false;
        }
        return this.equalsIgnoreUntil(other);
    }
}

