/*
 * Decompiled with CFR 0.152.
 */
package com.wix.restaurants.payments;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CibusCard
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String number;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String holderName;

    public CibusCard(String number, String holderName) {
        this.number = number;
        this.holderName = holderName;
    }

    public CibusCard() {
    }

    public CibusCard clone() {
        return new CibusCard(this.number, this.holderName);
    }

    public static List<CibusCard> clone(List<CibusCard> cards) {
        if (cards != null) {
            LinkedList<CibusCard> cloned = new LinkedList<CibusCard>();
            for (CibusCard card : cards) {
                cloned.add(card != null ? card.clone() : null);
            }
            return cloned;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CibusCard cibusCard = (CibusCard)o;
        return Objects.equals(this.number, cibusCard.number) && Objects.equals(this.holderName, cibusCard.holderName);
    }

    public int hashCode() {
        return Objects.hash(this.number, this.holderName);
    }

    public String toString() {
        return "CibusCard{number='" + this.number + '\'' + ", holderName='" + this.holderName + '\'' + '}';
    }
}

