/*
 * Decompiled with CFR 0.152.
 */
package com.wix.restaurants.payments;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.wix.restaurants.payments.BitpayPayment;
import com.wix.restaurants.payments.BitsofgoldPayment;
import com.wix.restaurants.payments.CashPayment;
import com.wix.restaurants.payments.CellarixPayment;
import com.wix.restaurants.payments.CibusPayment;
import com.wix.restaurants.payments.CreditcardPayment;
import com.wix.restaurants.payments.CreditmutuelPayment;
import com.wix.restaurants.payments.DebitPayment;
import com.wix.restaurants.payments.DeliveryclubPayment;
import com.wix.restaurants.payments.DeliverycomPayment;
import com.wix.restaurants.payments.MultipassPayment;
import com.wix.restaurants.payments.PaypalPayment;
import com.wix.restaurants.payments.PelecardPayment;
import com.wix.restaurants.payments.TenbisPayment;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=CashPayment.class, name="cash"), @JsonSubTypes.Type(value=CreditcardPayment.class, name="credit"), @JsonSubTypes.Type(value=DeliveryclubPayment.class, name="ru.delivery-club"), @JsonSubTypes.Type(value=DeliverycomPayment.class, name="com.delivery"), @JsonSubTypes.Type(value=BitpayPayment.class, name="com.bitpay"), @JsonSubTypes.Type(value=CellarixPayment.class, name="com.cellarix"), @JsonSubTypes.Type(value=BitsofgoldPayment.class, name="il.co.bitsofgold"), @JsonSubTypes.Type(value=PelecardPayment.class, name="com.pelecard"), @JsonSubTypes.Type(value=CreditmutuelPayment.class, name="fr.creditmutuel"), @JsonSubTypes.Type(value=MultipassPayment.class, name="il.co.multipass"), @JsonSubTypes.Type(value=TenbisPayment.class, name="10bis"), @JsonSubTypes.Type(value=DebitPayment.class, name="debit"), @JsonSubTypes.Type(value=PaypalPayment.class, name="paypal"), @JsonSubTypes.Type(value=CibusPayment.class, name="il.co.mysodexo")})
public abstract class Payment
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Integer amount = 0;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Map<String, String> externalIds = new LinkedHashMap<String, String>();

    public Payment() {
    }

    public Payment(Integer amount, Map<String, String> externalIds) {
        this.amount = amount;
        this.externalIds = externalIds;
    }

    public Payment clone() {
        return this.cloneImpl();
    }

    protected abstract Payment cloneImpl();

    public static List<Payment> clone(List<Payment> payments) {
        if (payments == null) {
            return null;
        }
        LinkedList<Payment> cloned = new LinkedList<Payment>();
        for (Payment payment : payments) {
            cloned.add(payment != null ? payment.clone() : null);
        }
        return cloned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payment payment = (Payment)o;
        return Objects.equals(this.amount, payment.amount) && Objects.equals(this.externalIds, payment.externalIds);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.externalIds);
    }
}

