<style>
.selectbox {
  position: relative;
  display: inline-block;
}

#selectbox-toggle {
  padding: 5px 10px;
  background-color: #f0f0f0;
  border: none;
  cursor: pointer;
}

#selectbox-dropdown {
  display: none;
  left: 0;
  z-index: 1;
  background-color: #ffffff;
  border: 1px solid #ccc;
  padding: 5px;
}

#selectbox-dropdown label {
  display: block;
}

#selectbox-dropdown input[type="checkbox"] {
  margin-right: 5px;
}

.square {
  width: 24px;
  height: 24px;
  background-color: lightgray;
  position: relative;
}

.triangle {
  width: 0;
  height: 0;

  border-top: 12px solid red; 
  border-left: 6px solid transparent;
  border-right: 6px solid transparent;

  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
}

</style>

<script>
document.addEventListener("DOMContentLoaded", function() {
  var toggleButton = document.getElementById("selectbox-toggle");
  var confirmButton = document.getElementById("selectbox-confirm");
  var dropdown = document.getElementById("selectbox-dropdown");
  var checkboxes = dropdown.getElementsByTagName("input");

  toggleButton.addEventListener("click", function() {
    if (dropdown.style.display === "block") {
      dropdown.style.display = "none";
    } else {
      dropdown.style.display = "block";
    }
  });

  confirmButton.addEventListener("click", function() {
    var selectedValues = [];
    for (var j = 0; j < checkboxes.length; j++) {
      if (checkboxes[j].checked) {
        selectedValues.push(checkboxes[j].value);
      }
    }
    alert(selectedValues);
    dropdown.style.display = "none";
  });

});
</script>

<body>
<div class="selectbox">
  <br><br><br>
  <button id="selectbox-toggle">Choice values</button>
  <div id="selectbox-dropdown">
    <label for="value1">
      <input type="checkbox" id="value1" value="value 1"> Value 1
    </label>
    <label for="value2">
      <input type="checkbox" id="value2" value="value 2">Value 2
    </label>
    <label for="value3">
      <input type="checkbox" id="value3" value="value 3"> Value 3
    </label>
  </div>
</div>
<button id="selectbox-confirm">Confirm</button>

<div class="square">
  <div class="triangle"></div>
</div>

</body>

