<html>

<head>
<title>Scrollbar example</title>
<style type="text/css">

#container {
 position  : absolute;
 top: 10px;
 left : 10px;
 width: 500px;
 height  : 200px;
 background : #EEE;
 overflow  : hidden;
 border  : 1px solid #666;
}

#content {
 position  : relative;
 width: 490px;
 left : 5px;
}

p {
 font : normal 10px/14px arial,helevetica,san-serif;
}

#scrollArea {
 position  : absolute;
 left : 515px;
 top: 10px;
 height  : 200px;
 width: 15px;
 border  : 1px solid white;
 overflow  : hidden;
}

#scroller {
 position  : absolute;
 top: -1px;
 width: 15px;
 background : #666;
 border-top : 1px solid #666;
 border-bottom : 1px solid #666;
}

</style>
<script type="text/javascript" src="w3domdrag.js"></script>
</head>

<body>
<script type="text/javascript">

//We wrap all the code in an object so that it doesn't interfere with any other code
var scroller = {
 init:function() {

  //collect the variables
  scroller.docH = document.getElementById("content").offsetHeight;
  scroller.contH = document.getElementById("container").offsetHeight;
  scroller.scrollAreaH = document.getElementById("scrollArea").offsetHeight;

  //calculate height of scroller and resize the scroller div
  //(however, we make sure that it isn't to small for long pages)
  scroller.scrollH = (scroller.contH * scroller.scrollAreaH) / scroller.docH;

  //if(scroller.scrollH < 15) scroller.scrollH = 15;
  document.getElementById("scroller").style.height = Math.round(scroller.scrollH) + "px";

  //what is the effective scroll distance once the scoller's height has been taken into account
  scroller.scrollDist = Math.round(scroller.scrollAreaH-scroller.scrollH);
 
  //make the scroller div draggable
  Drag.init(document.getElementById("scroller"),null,0,0,-1,scroller.scrollDist);

  //add ondrag function
  document.getElementById("scroller").onDrag = function (x,y) {
   var scrollY = parseInt(document.getElementById("scroller").style.top);
   var docY = 0 - (scrollY * (scroller.docH - scroller.contH) / scroller.scrollDist);
   document.getElementById("content").style.top = docY + "px";
  }
 }
}

onload = scroller.init;
</script>

<div id="scrollArea"><div id="scroller"></div></div>

<div id="container">

<div id="content">

<h1>The Raven</h1>
<p>Once upon a midnight dreary, while I pondered, weak and weary,<br>
Over many a quaint and curious volume of forgotten lore -<br>
While I nodded, nearly napping, suddenly there came a tapping,<br>
As of some one gently rapping - rapping at my chamber door.<br>
&quot;'Tis some visitor,&quot; I muttered, &quot;tapping at my chamber door -<br>
<!--

Only this and nothing more.&quot;</p>
<p>Ah, distinctly I remember, it was in the bleak December,<br>
And each separate dying ember wrought its ghost upon the floor.<br>
Eagerly I wished the morrow; - vainly I had sought to borrow<br>
From my books surcease of sorrow - sorrow for the lost Lenore -<br>
For the rare and radiant maiden whom the angels name Lenore -<br>
Nameless here for evermore.</p>
<p>And the silken sad uncertain rustling of each purple curtain<br>
Thrilled me - filled me with fantastic terrors never felt before;<br>

So that now, to still the beating of my heart, I stood repeating<br>
&quot;'Tis some visitor entreating entrance at my chamber door -<br>
Some late visitor entreating entrance at my chamber door -<br>
This it is and nothing more.&quot;</p>
<p>Presently my soul grew stronger; hesitating then no longer,<br>
&quot;Sir,&quot; said I, &quot;or Madam, truly yours forgiveness I implore;<br>
 But the fact is I was napping, and so gently you came rapping,<br>

 And so faintly you came tapping - tapping at my chamber door,<br>
 That I scarce was sure I heard you&quot; - here I opened wide the door: -<br>
 Darkness there, and nothing more.</p>
 <p>Deep into that darkness peering, long I stood there wondering, fearing,<br>
 Doubting, dreaming dreams no mortal ever dared to dream before;<br>
 But the silence was unbroken, and the stillness gave no token,<br>
 And the only word there spoken was the whispered word, &quot;Lenore!&quot; -<br>

This I whispered, and an echo murmured back the word, &quot;Lenore! -<br>
Merely this and nothing more.</p>
<p>Then into the chamber turning, all my soul within me burning,<br>
Soon again I heard a tapping, something louder than before.<br>
&quot;Surely,&quot; said I, &quot;surely that is something at my window lattice;<br>
Let me see, then, what thereat is, and this mystery explore -<br>
Let my heart be still a moment, and this mystery explore; -<br>

'Tis the wind and nothing more.&quot;</p>
<p>Open here I flung the shutter, when, with many a flirt and flutter,<br>
In there stepped a stately Raven of the saintly days of yore.<br>
Not the least obeisance made he; not an instant stopped or stayed he;<br>
But, with mien of lord or lady, perched above my chamber door -<br>
Perched upon a bust of Pallas just above my chamber door -<br>
Perched, and sat, and nothing more.</p>
<p>Then this ebony bird beguiling my sad fancy into smiling,<br>
By the grave and stern decorum of the countenance it wore,<br>

&quot;Though thy crest be shorn and shaven, thou,&quot; I said, &quot;art sure
no craven,<br>
Ghastly grim and ancient Raven wandering from the Nightly shore -<br>
Tell me what thy lordly name is on the Night's Plutonian shore!&quot;<br>
Quoth the Raven, &quot;Nevermore.&quot;</p>
<p>Much I marvelled this ungainly fowl to hear discourse so plainly,<br>
Though its answer little meaning - little relevancy bore;<br>
For we cannot help agreeing that no living human being<br>

Ever yet was blessed with seeing bird above this chamber door -<br>
Bird or beast upon the sculptured bust above his chamber door,<br>
With such name as &quot;Nevermore.&quot;</p>
<p>But the Raven, sitting lonely on that placid bust, spoke only<br>
That one word, as if his soul in that one word he did outpour.<br>
Nothing further then he uttered; not a feather then he fluttered -<br>
Till I scarcely more than muttered, &quot;Other friends have flown before -<br>
 On the morrow he will leave me, as my Hopes have flown before,&quot;<br>

 Then the bird said, &quot;Nevermore.&quot;</p>
 <p>Startled at the stillness broken by reply so aptly spoken,<br>
 &quot;Doubtless,&quot; said I, &quot;what it utters is its only stock and store,<br>
 Caught from some unhappy master, whom unmerciful Disaster<br>
 Followed fast and followed faster till his songs one burden bore -<br>
 Till the dirges of his Hope the melacholy burden bore<br>
 Of 'Never-nevermore.'&quot;</p>

 <p>But the Raven still beguiling all my sad soul into smiling,<br>
 Straight I wheeled a cushioned seat in front of bird and bust and door;<br>
 Then, upon the velvet sinking, I betook myself to linking<br>
 Fancy unto fancy, thinking what this ominous bird of yore -<br>
 What this grim, ungainly, ghastly, gaunt, and ominous bird of yore<br>
 Meant in croaking &quot;Nevermore.&quot;</p>
 <p>This I sat engaged in guessing, but no syllable expressing<br>
 To the fowl whose fiery eyes now burned into my bosom's core;<br>

 This and more I sat divining, with my head at ease reclining<br>
 On the cushion's velvet lining that the lamp-light gloated o'er,<br>
 But whose velvet violet lining with the lamp-light gloating o'er,<br>
 She shall press, ah, nevermore!</p>
 <p>Then, methought, the air grew denser, perfumed from an unseen censer<br>
 Swung by Seraphim whose foot-falls tinkled on the tufted floor.<br>
 &quot;Wretch,&quot; I cried, &quot;thy God hath lent thee - by these angels he
 hath sent thee<br>

 Respite - respite and nepenthe from thy memories of Lenore!<br>
 Quaff, oh quaff this kind nepenthe, and forget this lost Lenore!&quot;<br>
 Quoth the Raven, &quot;Nevermore.&quot;</p>
 <p>&quot;Prophet!&quot; said I, &quot;thing of evil! - prophet still, if bird or
devil! -<br>
Whether Tempter sent, or whether tempest tossed thee here ashore,<br>
Desolate yet all undaunted, on this desert land enchanted -<br>
On this Home by Horror haunted - tell me truly I implore -<br>

Is there - is there balm in Gilead? tell me - tell me, I implore!&quot;<br>
Quoth the Raven, &quot;Nevermore.&quot;</p>
<p>&quot;Prophet!&quot; said I, &quot;thing of evil - prophet still, if bird or
 devil!<br>
 By that Heaven that bends above us - by that God we both adore -<br>
 Tell this soul with sorrow laden if, within the distant Aidenn,<br>
 It shall clasp a sainted maiden whom the angels name Lenore.<br>
 Clasp a rare and radiant maiden whom the angels name Lenore.&quot;<br>
-->

 Quoth the Raven, &quot;Nevermore.&quot;</p>
 <p>&quot;Be that word our sign of parting, bird or fiend!&quot; I shrieked,
 upstarting -<br>
 &quot;Get thee back into the tempest and the Night's Plutonian shore!<br>
 Leave no black plume as a token of that lie thy soul hath spoken!<br>
 Leave my loneliness unbroken! - quit the bust above my door!<br>
 Take thy beak from out my heart, and take thy form from off my door!&quot;<br>
 Quoth the Raven, &quot;Nevermore.&quot;</p>

 <p>And the Raven, never flitting, still is sitting - still is sitting<br>
 On the pallid bust of Pallas just above my chamber door;<br>
 And his eyes have all the seeming of a Demon that is dreaming,<br>
 And the lamp-light o'er him streaming throws his shadow on the floor;<br>
 And my soul from out that shadow that lies floating on the floor<br>
 Shall be lifted - nevermore!


 </div>
 </div>
 </body>

 </html>

