package com.cav.mserver;

import java.io.*;

/**
 * Wrapper of mux command.
 * 
 * @author Uri Schor
 */
public class MuxSession extends MumpsConsoleSession {

	/** The command to run */
	private static final String MUX_COMMAND = "mux -U int ^MWRAP";

	/** The running Mumps console */
	private Process muxProcess;

	/**
	 * Create a new Mux session.
	 */
	public MuxSession() throws IOException {
		init();
	}

	/* (non-Javadoc)
	 * @see com.cav.mserver.MumpsSession#close()
	 */
	public void close() {
		executeCommand("HALT");
		// Just in case.
		muxProcess.destroy();
	}

	/* (non-Javadoc)
	 * @see com.cav.mserver.MumpsSession#init()
	 */
	public void init() throws IOException {
		// Run the Mumps console
		String mumpsCommand = Config.getString("child_proc.command");
		if (mumpsCommand == null) {
			mumpsCommand = MUX_COMMAND;
		}
		muxProcess = Runtime.getRuntime().exec(mumpsCommand);
		consoleStdin = new PrintStream(muxProcess.getOutputStream());
		consoleStdout = muxProcess.getInputStream();
		
		// Read until the first prompt
		InputStream is = new MumpsConsoleInputStream(this, muxProcess
				.getInputStream());
		while (is.read() != -1);
		is.close();
	}

}