package com.cav.mserver.tests;

import java.io.*;
import java.util.Properties;
import java.util.regex.*;

import com.cav.mserver.MuxSession;

/**
 * Runner of a single Mumps session in command line, for testing.
 * @author Uri Schor
 */
public class MuxSessionRunner {

	public static void main(String[] args) throws Exception {
		MuxSession session = new MuxSession();
		BufferedReader stdin = new BufferedReader(new InputStreamReader(
				System.in));
		Pattern varPattern = Pattern.compile("(.*)=(.*)");
		while (true) {
			System.out.println("Enter command (\"quit\" to exit): ");
			String command = stdin.readLine();
			if (command.equalsIgnoreCase("quit")) {
				System.out.println("Bye.");
				System.exit(0);
			}
			Properties parameters = new Properties();
			while (true) {
				System.out.println("Enter variable to set (name=value): ");
				String variable = stdin.readLine();
				Matcher matcher = varPattern.matcher(variable);
				if (matcher.matches()) {
					String name = matcher.group(1);
					String value = matcher.group(2);
					parameters.put(name, value);
				}
				else {
					break;
				}
			}
			BufferedReader output = new BufferedReader(new InputStreamReader(
					session.execute(command, parameters)));
			String outputLine;
			while ((outputLine = output.readLine()) != null) {
				System.out.println(outputLine);
			}
		}
	}
}