/*
 * Created on 20/04/2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package com.cav.taglibs.mumps;

import java.io.*;
import java.text.MessageFormat;
import java.util.*;
import java.util.logging.*;

import javax.servlet.jsp.JspWriter;

import org.apache.commons.pool.ObjectPool;

import com.cav.mserver.*;

/**
 * @author uri
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class JSPMumpsSession {

	private static Logger logger = Logger.getLogger(JSPMumpsSession.class
			.getPackage().getName());

	/** Code to run at the end of a session, to clear the M job */
	private static final String M_SESSION_CLEAR_CODE = "D CLEAR^%ZCAVJSP";

	/** Code to run, in order to switch to an M namespace */
	private static final MessageFormat M_SWITCH_NAMESPACE_CODE = new MessageFormat(
			"D CWD^%ZCAVJSP(\"{0}\")");

	/** Code to run, in order to get an M variable */
	private static final MessageFormat M_GET_VAR_CODE = new MessageFormat(
			"W {0}");

	/** Code to run, in order to check an M expression truth-value */
	private static final MessageFormat M_IF_CODE = new MessageFormat(
			"I {0} W 1");

	private static final Map EMPTY_ARGS = new HashMap();

	/** The M session */
	private MumpsSession mSession = null;

	/** The page output to write to, in case we're debugging the M code */
	private JspWriter out;
	
	private static final String VERSION = "1.2.2";
	
	static {
		logger.info("MJSP version " + VERSION + " starting");
	}
	
	/**
	 * Create a new JSP Mumps session
	 */
	public JSPMumpsSession() throws Exception {
		this(null);
	}
    
	/**
	 * Create a new JSP Mumps session, that will write all the M commands and
	 * output as comments in the JSP page.
	 * @param out The JSP page output
	 */
	public JSPMumpsSession(JspWriter out) throws Exception {
		try {
			mSession = (MumpsSession)MumpsSessionPool.instance().borrowObject();
			clearSession();
		} catch (Exception e) {
			ObjectPool pool = MumpsSessionPool.instance();
			StringBuffer status = new StringBuffer("Idle jobs: ");
			status.append(pool.getNumIdle());
			status.append(". Active jobs: ");
			status.append(pool.getNumActive());
			logger.log(Level.SEVERE,
					"Error borrowing Mumps session. " + status, e);
			throw e;
		}
		this.out = out;
	}

	/**
	 * Move to a given namespace. This should always be called, in the beginning
	 * of the session, unless this session does not need the HTTP arguments and 
	 * does not care for the namespace it runs in.
	 * @param namespace The namespace to switch to (e.g. "ACC", "LWK", ...)
	 * @param args The arguments to set. Some arguments are set automatically.
	 * TODO: specify the implicit arguments
	 */
	public void switchNamespace(String namespace, Map args) {
		String command = M_SWITCH_NAMESPACE_CODE
				.format(new Object[] { namespace });
		executeCommand(command, args);
	}

	/**
	 * Execute a command, ignoring its output
	 * @param command M command to execute 
	 * @param args The M variables to set (var name - > value)
	 */
	private void executeCommand(String command, Map args) {
		InputStream is = mSession.execute(command, args);
		if (out != null) {
			try {
				out.println("<!-- RUNNING: " + command + ", ARGS=" + args);
			} catch (IOException e) {
				logger.log(
					Level.SEVERE,
					"Error writing commandto page: " + command,
					e);
			}
		}
		int c;
		try {
			while ((c = is.read()) != -1) {
				if (out != null) {
					out.print((char)c);
				}
			}
		} catch (IOException e) {
			logger.log(
				Level.SEVERE,
				"Error reading command output: " + command,
				e);
		}
		if (out != null) {
			try {
				out.println(" -->");
			} catch (IOException e) {
				logger.log(
					Level.SEVERE,
					"Error writing commandto page: " + command,
					e);
			}
		}
	}

	/**
	 * Execute a command, returning its output
	 * @param command M command to execute 
	 * @param args The M variables to set (var name - > value)
	 */
	private String excuteCommandWithOutput(String command, Map args) {
		StringBuffer buf = new StringBuffer();
		InputStreamReader is = null;
		try {
			is = new InputStreamReader(mSession.execute(command, args), 
				"ISO-8859-8");
		} catch (UnsupportedEncodingException e) {
			logger.log(Level.SEVERE, "Error reading command output " + command, e);
			return "";
		}
		if (out != null) {
			try {
				out.println("<!-- RUNNING: " + command + ", ARGS=" + args);
			} catch (IOException e) {
				logger.log(
					Level.SEVERE,
					"Error writing command to page: " + command,
					e);
			}
		}
		int c;
		try {
			while ((c = is.read()) != -1) {
				buf.append((char)c);
			}
		} catch (IOException e) {
			logger.log(Level.SEVERE, "Error reading command output " + command, e);
			return "";
		}
		if (out != null) {
			try {
				out.print(buf.toString());
				out.println(" -->");
			} catch (IOException e) {
				logger.log(
					Level.SEVERE,
					"Error writing commandto page: " + command,
					e);
			}
		}
		return buf.toString();		
	}
	
	/**
	 * Execute an M expression
	 * @param expr
	 * @return
	 */
	public String exec(String expr) {
		return excuteCommandWithOutput(expr, EMPTY_ARGS);
	}

	/**
	 * Get an M expression
	 * @param expr
	 * @return
	 */
	public String get(String expr) {
		String command = M_GET_VAR_CODE.format(new Object[] { expr });
		return excuteCommandWithOutput(command, EMPTY_ARGS);
	}

	/**
	 * Get the thruth value of an M expression
	 * @param expr
	 * @return
	 */
	public boolean check(String expr) {
		// The check expression write "1" if the expression evaluates to "true"
		String checkExpr = M_IF_CODE.format(new Object[] { expr });
		String result = excuteCommandWithOutput(checkExpr, EMPTY_ARGS);
		logger.info("Result is <" + result + ">");
		return result.trim().equals("1");
	}
	
	public MumpsQuery query(String command) throws Exception {
		MumpsQuery query = new MumpsQuery(command, EMPTY_ARGS);
		query.execute(mSession);
		return query;
	}
	
	/**
	 * Set an M variable
	 * @param varName
	 * @param value
	 */
	public void set(String varName, String value) {
		Map args = new HashMap();
		args.put(varName, value);
		executeCommand("", args);
	}
	
	/**
	 * Close the JSP session, and release the M session back to the pool.
	 */
	public void close() {
		clearSession();
		try {
			MumpsSessionPool.instance().returnObject(mSession);
		} catch (Exception e) {
			logger.log(Level.SEVERE, "Error releasing Mumps session", e);
		}
	}

	/**
	 * Clear the session
	 */
	private void clearSession() {
		InputStream mumpsOutput = mSession.execute(
			M_SESSION_CLEAR_CODE,
			EMPTY_ARGS);
		try {
			while (mumpsOutput.read() != -1)
				;
		} catch (IOException e) {
			// Nah
		}
	}

	/**
	 * make a Mumps string out of a string 
	 * @param str The original string
	 * @return M canonic string
	 */
	public static String toMString(String str) {
		return "\"" + str.replaceAll("\"", "\"\"") + "\"";
	}
}