package com.cav.taglibs.mumps;

import java.io.IOException;
import java.util.List;
import java.util.logging.*;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * A tag that gets a Mumps query row's column.
 * The column value is set to an M variable (default var name is "%piece") and 
 * to JSP variable (default var name is "_piece").
 * @author uri
 */
public class MumpsGetColumnTag extends TagSupport {

	private static Logger logger = Logger.getLogger(MumpsGetColumnTag.class
			.getPackage().getName());

	Integer position;

	private Boolean silent = Boolean.FALSE;

	private String varName = "_piece";

	public MumpsGetColumnTag() {
	}

	/**
	 * @return Returns the namespace.
	 */
	public Integer getPosition() {
		return position;
	}

	/**
	 * @param namespace The namespace to set.
	 */
	public void setPosition(Integer position) {
		this.position = position;
	}

	/**
	 * @return
	 */
	public String getVarName() {
		return varName;
	}

	/**
	 * @param varName
	 */
	public void setVarName(String varName) {
		this.varName = varName;
	}

	/**
	 * @return Returns the silent.
	 */
	public Boolean getSilent() {
		return silent;
	}

	/**
	 * @param silent The silent to set.
	 */
	public void setSilent(Boolean silent) {
		this.silent = silent;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#doEndTag()
	 */
	public int doStartTag() throws JspException {
		MumpsForeachRowTag foreachTag = (MumpsForeachRowTag)findAncestorWithClass(
			this,
			MumpsForeachRowTag.class);
		if (foreachTag == null) {
			throw new JspTagException(
					"A foreachRow tag must be nested within a query tag.");
		}
		List row = foreachTag.getRow();
		int pos = position.intValue() - 1;
		try {
			if (pos >= row.size() || pos < 0) {
				// column out of range
				pageContext.getOut().print(
					"Invalid position <" + position + "> should be [1, "
		+ row.size() + "]");
			} else {
				String piece = (String)row.get(pos);
				if (!silent.booleanValue()) {
					pageContext.getOut().print(piece);
				}
				if (getVarName() != null && getVarName().length() > 0) {
					pageContext.setAttribute(getVarName(), piece);
					MumpsSessionTag sessionTag = (MumpsSessionTag) findAncestorWithClass(
							this, MumpsSessionTag.class);
					JSPMumpsSession session = sessionTag.getSession();

					session.set(getVarName().replaceAll("_", "%"),
							JSPMumpsSession.toMString(piece));
				}
			}
		} catch (IOException e) {
			logger.log(Level.SEVERE, "Error writing to page output", e);
		}
		return EVAL_BODY_INCLUDE;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#doEndTag()
	 */
	public int doEndTag() throws JspException {
		// We have to call release() explicitly, since it doesn't have to be 
		// called by the container each time, according to the spec
		release();
		return EVAL_PAGE;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#setPageContext(javax.servlet.jsp.PageContext)
	 */
	public void setPageContext(PageContext pageContext) {
		super.setPageContext(pageContext);
		this.pageContext = pageContext;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#release()
	 */
	public void release() {
	}
}