package com.cav.taglibs.mumps;

import java.util.logging.Logger;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * A tag that performs body iff nesting query yielded empty result set 
 * 
 * @author uri
 */
public class MumpsGetHeaderTag extends TagSupport {

	private static Logger logger = Logger.getLogger(MumpsGetHeaderTag.class
			.getPackage().getName());

	public MumpsGetHeaderTag() {
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#doEndTag()
	 */
	public int doStartTag() throws JspException {
		MumpsForeachColumnTag foreachColTag = (MumpsForeachColumnTag)findAncestorWithClass(
			this,
			MumpsForeachColumnTag.class);
		if (foreachColTag == null) {
			throw new JspTagException(
					"A getHeader tag must be nested within a foreachCol tag.");
		}
		try {
			pageContext.getOut().print(foreachColTag.getColName());
		} catch (Exception ex) {
			throw new JspException("IO problems");
		}
		return SKIP_BODY;
	}
}