package com.cav.taglibs.mumps;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * A tag that reads an M expression into JSP variable
 * @author uri
 */
public class MumpsGetTag extends TagSupport {

	private String varValue;

	private String varName;

	public MumpsGetTag() {
	}

	/**
	 * @return Returns the varName.
	 */
	public String getVarValue() {
		return varValue;
	}

	/**
	 * @param varName The varName to set.
	 */
	public void setVarValue(String varName) {
		this.varValue = varName;
	}
	
	/**
	 * @return the varName
	 */
	public String getVarName() {
		return varName;
	}

	/**
	 * @param varName the varName to set
	 */
	public void setVarName(String varName) {
		this.varName = varName;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.SimpleTagSupport#doTag()
	 */
	public int doStartTag() throws JspException {
		MumpsSessionTag sessionTag = (MumpsSessionTag)findAncestorWithClass(
			this,
			MumpsSessionTag.class);
		if (sessionTag == null) {
			throw new JspTagException(
					"An out tag must be nested within a session tag.");
		}
		JSPMumpsSession session = sessionTag.getSession();
		String value = session.get(varValue);
		pageContext.setAttribute(varName, value);
		return SKIP_BODY;
	}
}