package com.cav.taglibs.mumps;

import java.util.logging.Logger;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.TagSupport;

import com.cav.mserver.MumpsQuery;

/**
 * A tag that performs a Mumps query.
 * 
 * @author uri
 */
public class MumpsQueryTag extends TagSupport {

	private static Logger logger = Logger.getLogger(MumpsQueryTag.class
			.getPackage().getName());

	private String expr;

	private MumpsQuery query;

	private String varName = "_colCount";
	
	public MumpsQueryTag() {

	}

	/**
	 * @return Returns the namespace.
	 */
	public String getExpr() {
		return expr;
	}

	/**
	 * @param namespace The namespace to set.
	 */
	public void setExpr(String expr) {
		this.expr = expr;
	}
	
	/**
	 * @return Returns the varName.
	 */
	public String getVarName() {
		return varName;
	}
	
	/**
	 * @param varName The varName to set.
	 */
	public void setVarName(String varName) {
		this.varName = varName;
	}
	
	/**
	 * @return Returns the session.
	 */
	public MumpsQuery getQuery() {
		return query;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#doEndTag()
	 */
	public int doStartTag() throws JspException {
		MumpsSessionTag sessionTag = (MumpsSessionTag)findAncestorWithClass(
			this,
			MumpsSessionTag.class);
		if (sessionTag == null) {
			throw new JspTagException(
					"A query tag must be nested within a session tag.");
		}
		JSPMumpsSession session = sessionTag.getSession();
		try {
			query = session.query(expr);
			pageContext.setAttribute(getVarName(), new Integer(query
					.getColumnTitles().size()));
		} catch (Exception e) {
			throw new JspTagException("Error executing query", e);
		}
		return EVAL_BODY_INCLUDE;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#doEndTag()
	 */
	public int doEndTag() throws JspException {
		// We have to call release() explicitly, since it doesn't have to be 
		// called by the container each time, according to the spec
		release();
		return EVAL_PAGE;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#setPageContext(javax.servlet.jsp.PageContext)
	 */
	public void setPageContext(PageContext pageContext) {
		super.setPageContext(pageContext);
		this.pageContext = pageContext;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#release()
	 */
	public void release() {
		if (query != null) {
			query.clear();
		}
		query = null;
	}
}