package com.cav.taglibs.mumps;

import java.util.logging.Logger;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.TagSupport;

import com.cav.mserver.MumpsQuery;

/**
 * A tag that performs body iff nesting query yielded empty result set 
 * 
 * @author uri
 */
public class MumpsRowCountTag extends TagSupport {

	private static Logger logger = Logger.getLogger(MumpsRowCountTag.class
			.getPackage().getName());

	public MumpsRowCountTag() {
	}

	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#doEndTag()
	 */
	public int doStartTag() throws JspException {
		MumpsQueryTag queryTag = (MumpsQueryTag)findAncestorWithClass(
			this,
			MumpsQueryTag.class);
		if (queryTag == null) {
			throw new JspTagException(
					"A rowCount tag must be nested within a query tag.");
		}
		MumpsQuery query = queryTag.getQuery();
		try {
			pageContext.getOut().print(query.getResultSet().size());
		} catch (Exception ex) {
			throw new JspException("IO problems");
		}
		return SKIP_BODY;
	}
}