<html>
<!-- Copyright (c) 2005 Cav Systems Ltd.  All rights reserved. -->
<body bgcolor=white>
<%@ taglib uri="http://cav.co.il/taglibs/mumps" prefix="m" %>
<p>

<m:session namespace="USER">
This page demonstrates how to use the <b>SetSessionId</b> tag.
The session ID is the way to follow a user session, e.g. an order process, a wizard, etc.
<br>
<br>
<!-- The session id is kept in the M JB variable. -->
<!-- NOTE: You should set the session ID only once in a session and refer to it as it goes on. -->

<!-- Let us check if JB was passed in the URL, as argument -->
<m:if expr='$D(%ARG("JB"))'>
	Session was passed as argument. Setting session ID to it<br>
	<m:setSessionId expr='%ARG("JB")'/>
</m:if>
<m:if expr="$D(JB)">
	Inside a session...
</m:if>
<m:if expr="'$D(JB)">
	Generating random session ID... <m:setSessionId expr="$R(1000)"/>
</m:if>
<br>
The session ID is set in M to: <b><m:out expr="JB"/></b>
<br>
The session ID is also set to the JSP session: <b><%= (String)session.getAttribute("_sessid") %></b>
<br>
now reload the page (refresh, F5 key in explorer) and see that the session ID remains

<p>
The following demonstrates the use of HTTP sessions. You can add or delete
named values to a session. The same session can be retrieved next time the
user visits the page via a browser cookie. Use this form to see your additions
and deletions at work. Check the code to see how adding and deleting session
name/value pairs works.
</p>

<m:if expr='$D(%ARG("AddValue"))'>
	<m:set varName='^CacheTempJSP(JB,%ARG("NameField"))' varValue='%ARG("ValueField")'/>
</m:if>
<m:if expr='$D(%ARG("DeleteValue"))'>
	<m:exec expr='KILL ^CacheTempJSP(JB,%ARG("NameField"))'/>
</m:if>
<h3>
The values are stores here to ^CacheTempJSP() global:
</h3>
<hr/>
<pre>
<m:exec expr='S I="" F  S I=$O(^CacheTempJSP(JB,I)) Q:I=""  W I,"=",^(I),!'/>
</pre>
<hr/>

<form method="post" name="SetSessionId" action="SetSessionId.jsp">
<center>
<table border=0 cellspacing=2 cellpadding=5 width=400>
<th>Name to add/delete</th>
<th>Value</th>
<tr>
<td><input type="text" name="NameField"></td>
<td><input type="text" name="ValueField"></td>
</tr>

<tr>
<td colspan=2 align=center><input type="submit" value=" Add " name="AddValue"></td>
</tr>
<tr>
<td colspan=2 align=center><input type="submit" value="Delete" name="DeleteValue"></td>
</tr>
</table>
</center>

</form>
<p>

</m:session>

</body>
</html>
