<!DOCTYPE html>
<html>
 <%@ taglib uri="http://cav.co.il/taglibs/mumps" prefix="m" %>
 <m:session namespace="USER">
 <%@ include file="w1jbarg.jsp" %>

 <head>
 <title>Geocoding service</title>
 <meta name="viewport" content="initial-scale=1.0, user-scalable=no">
 <meta charset="utf-8">

 <style>
   /* Always set the map height explicitly to define the size of the div
    * element that contains the map. */
   #map {
     height: 100%;
   }

   /* Optional: Makes the sample page fill the window. */
   html, body {
     height: 100%;
     margin: 0;
     padding: 0;
   }

  </style>

  <script>
   <%@ include file="w1procg.jsp" %>
   <%@ include file="w4map.jsp" %>

   function Current()
   {
   } 

   function Close()
   {
    CloseWindow()
   }

   function ShowMap(map,nmap)
   {
     //alert("ShowMap.nmap="+nmap+"  map="+map)
     if ( map == null || map == undefined ) return
     if ( +nmap == 0 ) return

     var a,prm

    //------- Paint Polygons ------
    var np='<m:out expr='$G(%ARG("NP"))' />'
    var func='<m:out expr='$G(%ARG("FUNC"))' />'

    if ( isNaN(np) || np == '' )
    { 
     np="ALL"
    }
   
    ShowPolygons(map,np,'N') 
   }
  </script>

</head>

<body>
 <div id="hd" style="position:absolute;top:1px;left:0;width:100%;height:60px" dir="<m:out expr='$$^%W1DIR' />" >
  <m:exec expr='D HD^W4MAP' />
 </div>

 <div id="map" style="position:absolute;top:62px;left:0;width:100%;height:90%"></div>

  <script>

  function initMap() {
   var map = new google.maps.Map(document.getElementById('map'), {
   zoom: 12 ,
   center: {lat: <m:out expr='$$MAPLAT^W4PLGN(1)' /> , lng: <m:out expr='$$MAPLNG^W4PLGN(1)' /> }
   });

   google.maps.event.addListener(map,'zoom_changed', function() {
     var zoomLevel=map.getZoom();
     var prm="w4maploc.myMap-zoom;"+zoomLevel
     var a=<m:serverExec expr='S PRM=$$^W4PRMSRV(PRM) D PUT^%W1PRM("ZOOM",PRM) W 1' varName='PRM' varValue='prm' />
   })
   ShowMap(map,1)

   var geocoder = new google.maps.Geocoder();
   geocodeAddress(geocoder, map)
  } // -- end initMap


  function geocodeAddress(geocoder, resultsMap)
  {
    var adr = '<m:out expr='$G(%ARG("ADR"))' />'
    var adr=InvH(adr)
    address=Txt4Inp(adr)
    //alert("address="+address)

    geocoder.geocode({'address': address}, function(results, status) {
     //alert("status="+status)
     if (status === 'OK') {
       var loc=results[0].geometry.location
       var pid=results[0].place_id
       var bnd=results[0].geometry.bounds
       var adr=results[0].formatted_address
       var short=results[0].address_components[0].short_name
       var long=results[0].address_components[0].long_name
       var plc=results[0].address_components[0].postcode_localities
       var tps=results[0].address_components[0].types[0]

       //alert("loc="+loc+"  place id="+pid+"  <br>bounds="+bnd +" <br> adr="+adr+"  <br>short="+short+"  <br>long="+long+"  <br>plc="+plc+"  <br>tps="+tps )

       resultsMap.setCenter(loc);

       var marker = new google.maps.Marker({
        map: resultsMap,
        position: loc // results[0].geometry.location
       }); // -- marker
     }  // -- status='OK'

     else {
       alert('Search error : ' + status);
          }
        });
    } // ---- end function geocodeAddress
  </script>

  <script async defer
    src="<m:out expr='$$^W4GGLKEY("initMap")' />"
  >
  </script>

  </body>
 
  </m:session>
 </html>









