<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ page import="javax.servlet.*"%>
<%@ page import="javax.servlet.http.*,javax.servlet.jsp.*"%>
<%@ page import="java.util.Set,java.util.Iterator,java.io.IOException"%>

<%! private void compileAllJsps
     (PageContext pageContext, JspWriter out,
      HttpServletRequest request,HttpServletResponse response, 
      String uripath)
         throws IOException, ServletException {

     Set set = pageContext.getServletContext().getResourcePaths(uripath);
     for (Iterator iter = set.iterator(); iter.hasNext();) {
         String uri = (String) iter.next();
         if (uri.endsWith(".jsp")) {
             out.write("<li>"+ uri +"</li>");
             out.flush();
             RequestDispatcher rd = 
                getServletContext().getRequestDispatcher(uri);
             if (rd == null) {
                 throw new Error(uri +" - not found");
                 }
             rd.include(request, response);
         }
         else if (uri.endsWith("/")) {
             compileAllJsps(pageContext, out, request, response, uri); 
         }
     }
   }
%>

<html><head><title>Precompiling *.JSPs</title></head>
<body><h4>Precompiling *.JSPs:</h4>
<ul>
<%
  HttpServletRequest req = new HttpServletRequestWrapper(request) {
      public String getQueryString() {
          // can be "jsp_precompile=true"
          return "jsp_precompile";
          };
  };
  compileAllJsps(pageContext, out, req, response, "/");
%>
</ul>
<h4>Done.</h4>
</body> </html>
