// Execute code on mumps server. Use a servlet on the
// same server and port from which this applet has been loaded.
// @param mCodeKey encoded code to execute
// @param params the paramters to set in the M env prior to executing the code
// @return result of code execution 
function callMumpsServlet(mCodeKey, params) {
	var url = document.location;
	var pathTokens = url.pathname.split("/");
	var appName = pathTokens.length > 1 ? (pathTokens[1] + "/") : "";
	var servletUrl = url.protocol + "//" + url.host + "/" + appName + "mserver" + "?CODE=" + mCodeKey + "&ARGS=" + encodeURIComponent(params);
	//alert(servletUrl);
	var result = makeRequest(servletUrl);
	if (convertHebrewToUnicode) {
		return asciiToUnicodeHebrew(result);
	}
	// else
	return result;
}

// Convert each ASCII Hebrew character in a string to Unicode
// @param text
// @return the string, with Hebrew characters as UNICODE
function asciiToUnicodeHebrew(text) {
	var sbuf = "";
	for (var i = 0; i < text.length; i++) {
		var c = text.charCodeAt(i);
		if (c > 223 && c < 256) {
			c += 1264;
		}
		sbuf += String.fromCharCode(c);
	}
	return sbuf;
}

// Convert each Unicode Hebrew character in a string, to 7-bit OLDCODE
// (Alef character is located at 96). 
// @param text A UNICODE string
// @return the string, with Hebrew characters as regular Latin Letters (7-bit OLDCODE)
function unicodeToASCIIHebrew(text) {
	var sbuf = "";
	for (var i = 0; i < text.length; i++) {
		var c = text.charCodeAt(i);
		if (c > 1487 && c < 1521) {
			c -= 1392;
		}
		if (c > 223 &&  c < 256) {
			c -= 128;
		}
		sbuf += String.fromCharCode(c);
	}
	return sbuf;
}

function makeRequest(url) {

      http_request = false;

      if (window.XMLHttpRequest) { // Mozilla, Safari,...
          http_request = new XMLHttpRequest();
          if (http_request.overrideMimeType) {
              http_request.overrideMimeType('text/xml');
          }
      } else if (window.ActiveXObject) { // IE
          try {
              http_request = new ActiveXObject("Msxml2.XMLHTTP");
          } catch (e) {
              try {
              http_request = new ActiveXObject("Microsoft.XMLHTTP");
              } catch (e) {}
          }
      }

      if (!http_request) {
          alert('Giving up :( Cannot create an XMLHTTP instance');
          return "";
      }
      //http_request.onreadystatechange = alertContents;
      http_request.open('GET', url, false);
      http_request.send(null);
      if (http_request.readyState == 4) {
          if (http_request.status == 200) {
              //return http_request.responseText;
              var xmldoc = http_request.responseXML;
              var root_node = xmldoc.getElementsByTagName('root').item(0);
              if (root_node.firstChild == null) {
                 return '';
              }
              return root_node.firstChild.data;
          } else {
              return 'There was a problem with the request.';
          }
      }

}

// use applet to execute mumps code on server
// pass all from field names and data to mumps server, unless a specifig field
// name is passed in the second argument
function executeMumps(toExecute, fieldName, varName, varValue) {
	var framesLength = document.forms.length ; //number of forms in the document above
	var eLength ; // number of elements in a form
	var fName ; // field name
	var fVal ; // field value
	var valuesString = "" ; // string of names and values
	var notFirstKey = false;
	if (varName != undefined) {
		varValue = varValue.replace(/"/g,"\"\"\"\"");
		varValue = varValue.replace(/\r?\n/g,"_");
		valuesString = varName  + "=\"\"" + varValue + "\"\"";
		notFirstKey = true;
	}	
	// iterate over all forms and all their value
	for (i=0; i<framesLength; i++) {
		eLength = document.forms[i].elements.length;
		for (j=0; j<eLength; j++) {
			fName = document.forms[i].elements[j].name;
			if (fieldName != undefined && fieldName != fName) {
				continue;
			} 
			if (fName == "") {
				continue;
			}
			if (document.forms[i].elements[j].type == 'button') {
				continue;
			} else if (document.forms[i].elements[j].type == 'checkbox') {
				// in checkboxes, get the "checked" field
				fVal = "" + (document.forms[i].elements[j].checked ? 1 : 0);
			} else {
				// not checkbox - taek "value" field
				if (document.forms[i].elements[j].type == 'radio') {
					// in radio, get the value of the checked radio
					if (! document.forms[i].elements[j].checked) {
						continue;
					}
				}			
				fVal  = "" + document.forms[i].elements[j].value;
			}
			// replace quotes and newlines in order to comply with
			// mumps string literal syntax
			fVal = fVal.replace(/"/g,"\"\"\"\"");
			fVal = fVal.replace(/\r?\n/g,"_");
			if (notFirstKey){
				// seperate arguments with commas
				valuesString = valuesString + ",";
			}else{
				notFirstKey = true;
			}
			// add current value
			valuesString = valuesString + fName  + "=\"\"" + fVal + "\"\"";
		}
	}
	// alert("values: " + valuesString);
        if (convertHebrewToUnicode) {
		valuesString = unicodeToASCIIHebrew(valuesString);	
	}
	// do the execution via applet
	return callMumpsServlet(toExecute,"\"" + valuesString + "\"");
	//return(document.MApplet.mExecute(toExecute,"\"" + valuesString + "\""));
}

